/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.tasks;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.api.AndroidApplicationVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J$\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/appmetrica/analytics/gradle/common/tasks/CheckDependenciesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowTwoAppMetricas", "", "getAllowTwoAppMetricas", "()Z", "setAllowTwoAppMetricas", "(Z)V", "variant", "Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;", "getVariant", "()Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;", "setVariant", "(Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;)V", "check", "", "findDependency", "", "", "dependencyToFind", "initialDependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "common"})
public class CheckDependenciesTask
extends DefaultTask {
    @Internal
    private boolean allowTwoAppMetricas;
    @Internal
    public AndroidApplicationVariant variant;

    public final boolean getAllowTwoAppMetricas() {
        return this.allowTwoAppMetricas;
    }

    public final void setAllowTwoAppMetricas(boolean bl) {
        this.allowTwoAppMetricas = bl;
    }

    @NotNull
    public final AndroidApplicationVariant getVariant() {
        AndroidApplicationVariant androidApplicationVariant = this.variant;
        if (androidApplicationVariant != null) {
            return androidApplicationVariant;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        return null;
    }

    public final void setVariant(@NotNull AndroidApplicationVariant androidApplicationVariant) {
        Intrinsics.checkNotNullParameter((Object)androidApplicationVariant, (String)"<set-?>");
        this.variant = androidApplicationVariant;
    }

    @TaskAction
    public final void check() {
        List<List<String>> appMetricaDependencies = this.findDependency("io.appmetrica.analytics:analytics");
        List<List<String>> appMetricaLegacyDependencies = this.findDependency("com.yandex.android:mobmetricalib");
        if (!((Collection)appMetricaDependencies).isEmpty() && !((Collection)appMetricaLegacyDependencies).isEmpty()) {
            Log.warn$default(Log.INSTANCE, "Using both io.appmetrica.analytics:analytics and com.yandex.android:mobmetricalib is not recommended", null, 2, null);
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)appMetricaDependencies, (Iterable)appMetricaLegacyDependencies);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl = false;
                Log.warn$default(Log.INSTANCE, "Found dependency " + CollectionsKt.joinToString$default((Iterable)it, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
            }
            if (!this.allowTwoAppMetricas) {
                throw new IllegalStateException("Using both io.appmetrica.analytics:analytics and com.yandex.android:mobmetricalib is not recommended");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<String>> findDependency(String dependencyToFind) {
        List list;
        Set set;
        ResolvedConfiguration resolvedConfiguration;
        Log.INSTANCE.debug("Trying to find " + dependencyToFind);
        Configuration configuration = (Configuration)this.getProject().getConfigurations().findByName(this.getVariant().getName() + "RuntimeClasspath");
        if (configuration != null && (resolvedConfiguration = configuration.getResolvedConfiguration()) != null && (set = resolvedConfiguration.getFirstLevelModuleDependencies()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = set;
            boolean $i$f$flatMap22 = false;
            void var7_8 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ResolvedDependency it = (ResolvedDependency)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Iterable list$iv$iv = this.findDependency(it, dependencyToFind);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $i$f$flatMap22 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it).isEmpty();
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<List<String>> findDependency(ResolvedDependency initialDependency, String dependencyToFind) {
        Set viewedDependencies = new LinkedHashSet();
        List result = new ArrayList();
        List path = new ArrayList();
        CheckDependenciesTask.findDependency$dps(viewedDependencies, path, dependencyToFind, result, initialDependency);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final void findDependency$dps(Set<String> viewedDependencies, List<ResolvedDependency> path, String $dependencyToFind, List<List<String>> result, ResolvedDependency curDep) {
        String depName = curDep.getModuleGroup() + ":" + curDep.getModuleName();
        Log.INSTANCE.debug("Searching in " + curDep.getName());
        viewedDependencies.add(depName);
        path.add(curDep);
        if (Intrinsics.areEqual((Object)depName, (Object)$dependencyToFind)) {
            ResolvedDependency it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = path;
            Object object = Log.INSTANCE;
            boolean $i$f$map = false;
            void var8_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ResolvedDependency resolvedDependency = (ResolvedDependency)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            ((Log)object).debug("Found at " + (List)destination$iv$iv);
            $this$map$iv = path;
            object = result;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ResolvedDependency)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            object.add((List)destination$iv$iv);
        } else {
            void $this$forEach$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Log.INSTANCE.debug("Going to children");
            Set set = curDep.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"curDep.children");
            Iterable $this$map$iv = set;
            boolean $i$f$filterNot = false;
            void $this$mapTo$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ResolvedDependency it = (ResolvedDependency)element$iv$iv;
                boolean bl = false;
                if (viewedDependencies.contains(it.getModuleGroup() + ":" + it.getModuleName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = $this$filterNot$iv = (List)destination$iv$iv;
            boolean bl = false;
            Log.INSTANCE.debug("Found " + it.size() + " matching children");
            $this$filterNot$iv = $this$filterNot$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResolvedDependency it2 = (ResolvedDependency)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                CheckDependenciesTask.findDependency$dps(viewedDependencies, path, $dependencyToFind, result, it2);
            }
        }
        path.remove(path.size() - 1);
    }
}

