/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.tasks;

import io.appmetrica.analytics.gradle.common.FileUploader;
import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.analytics.Analytics;
import io.appmetrica.analytics.gradle.common.analytics.AnalyticsReporter;
import io.appmetrica.analytics.gradle.common.analytics.AnalyticsStub;
import io.appmetrica.analytics.gradle.common.provider.FileInfo;
import io.appmetrica.analytics.gradle.common.provider.FileProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002J\b\u0010+\u001a\u00020)H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR*\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u001a8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u001a8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$\u00a8\u0006,"}, d2={"Lio/appmetrica/analytics/gradle/common/tasks/UploadTask;", "Lorg/gradle/api/DefaultTask;", "()V", "analytics", "Lio/appmetrica/analytics/gradle/common/analytics/Analytics;", "getAnalytics", "()Lio/appmetrica/analytics/gradle/common/analytics/Analytics;", "analytics$delegate", "Lkotlin/Lazy;", "enableAnalytics", "", "getEnableAnalytics", "()Z", "setEnableAnalytics", "(Z)V", "fileProvider", "Lio/appmetrica/analytics/gradle/common/provider/FileProvider;", "getFileProvider", "()Lio/appmetrica/analytics/gradle/common/provider/FileProvider;", "setFileProvider", "(Lio/appmetrica/analytics/gradle/common/provider/FileProvider;)V", "offline", "getOffline", "setOffline", "paramsForAnalytics", "", "", "", "getParamsForAnalytics", "()Ljava/util/Map;", "setParamsForAnalytics", "(Ljava/util/Map;)V", "postApiKey", "getPostApiKey", "()Ljava/lang/String;", "setPostApiKey", "(Ljava/lang/String;)V", "uploadUrl", "getUploadUrl", "setUploadUrl", "checkParameters", "", "getUserId", "upload", "common"})
public class UploadTask
extends DefaultTask {
    @Internal
    public String postApiKey;
    @Internal
    public FileProvider fileProvider;
    @Internal
    public String uploadUrl;
    @Internal
    private boolean offline;
    @Internal
    private boolean enableAnalytics = true;
    @Internal
    @NotNull
    private Map<String, ? extends Object> paramsForAnalytics = MapsKt.emptyMap();
    @NotNull
    private final Lazy analytics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Analytics>(this){
        final /* synthetic */ UploadTask this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Analytics invoke() {
            return this.this$0.getEnableAnalytics() ? (Analytics)new AnalyticsReporter(UploadTask.access$getUserId(this.this$0, this.this$0.getPostApiKey())) : (Analytics)new AnalyticsStub();
        }
    }));

    @NotNull
    public final String getPostApiKey() {
        String string = this.postApiKey;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"postApiKey");
        return null;
    }

    public final void setPostApiKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.postApiKey = string;
    }

    @NotNull
    public final FileProvider getFileProvider() {
        FileProvider fileProvider = this.fileProvider;
        if (fileProvider != null) {
            return fileProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileProvider");
        return null;
    }

    public final void setFileProvider(@NotNull FileProvider fileProvider) {
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"<set-?>");
        this.fileProvider = fileProvider;
    }

    @NotNull
    public final String getUploadUrl() {
        String string = this.uploadUrl;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"uploadUrl");
        return null;
    }

    public final void setUploadUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.uploadUrl = string;
    }

    public final boolean getOffline() {
        return this.offline;
    }

    public final void setOffline(boolean bl) {
        this.offline = bl;
    }

    public final boolean getEnableAnalytics() {
        return this.enableAnalytics;
    }

    public final void setEnableAnalytics(boolean bl) {
        this.enableAnalytics = bl;
    }

    @NotNull
    public final Map<String, Object> getParamsForAnalytics() {
        return this.paramsForAnalytics;
    }

    public final void setParamsForAnalytics(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.paramsForAnalytics = map;
    }

    private final Analytics getAnalytics() {
        Lazy lazy = this.analytics$delegate;
        return (Analytics)lazy.getValue();
    }

    @TaskAction
    public final void upload() {
        Analytics.DefaultImpls.reportEvent$default(this.getAnalytics(), "upload", null, this.paramsForAnalytics, 2, null);
        List<FileInfo> files = this.getFileProvider().getUploadFiles();
        if (this.offline) {
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileInfo fileInfo = (FileInfo)element$iv;
                boolean bl = false;
                String string = "Archive was not uploaded since '%s'. You can manually upload file %s to AppMetrica";
                Object[] objectArray = new Object[]{"Offline mode enabled", fileInfo.getFile().getAbsolutePath()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                Log.warn$default(Log.INSTANCE, string2, null, 2, null);
            }
        } else {
            this.checkParameters();
            FileUploader fileUploader = new FileUploader(this.getUploadUrl(), this.getPostApiKey());
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileInfo fileInfo = (FileInfo)element$iv;
                boolean bl = false;
                try {
                    fileUploader.uploadFile(fileInfo.getFile());
                    Log.warn$default(Log.INSTANCE, "File " + fileInfo.getEntryName() + " successfully uploaded.", null, 2, null);
                }
                catch (Throwable e) {
                    String string = "Archive was not uploaded since '%s'. You can manually upload file %s to AppMetrica";
                    Object[] objectArray = new Object[]{e.getMessage(), fileInfo.getFile().getAbsolutePath()};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                    Log.error$default(Log.INSTANCE, string3, null, 2, null);
                    Analytics analytics2 = this.getAnalytics();
                    String string4 = e.getMessage();
                    if (string4 == null) {
                        string4 = e.getClass().getSimpleName();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"e.message ?: e::class.java.simpleName");
                    analytics2.reportError(string4, e, this.paramsForAnalytics);
                    throw e;
                }
            }
        }
    }

    private final void checkParameters() {
        if (((CharSequence)this.getPostApiKey()).length() == 0) {
            IllegalArgumentException it = new IllegalArgumentException("Post API key is empty for task " + this.getName() + ".");
            boolean bl = false;
            this.getAnalytics().reportError("Post API key is empty", it, this.paramsForAnalytics);
            throw it;
        }
    }

    private final String getUserId(String postApiKey2) {
        return String.valueOf(Math.abs(postApiKey2.hashCode()));
    }

    public static final /* synthetic */ String access$getUserId(UploadTask $this, String postApiKey2) {
        return $this.getUserId(postApiKey2);
    }
}

