/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common;

import io.appmetrica.analytics.gradle.common.Log;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/appmetrica/analytics/gradle/common/FileUploader;", "", "url", "", "postApiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "retryCount", "", "uploadFile", "", "zippedFile", "Ljava/io/File;", "common"})
public final class FileUploader {
    @NotNull
    private final String url;
    @NotNull
    private final String postApiKey;
    private int retryCount;

    public FileUploader(@NotNull String url, @NotNull String postApiKey2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)postApiKey2, (String)"postApiKey");
        this.url = url;
        this.postApiKey = postApiKey2;
    }

    public final void uploadFile(@NotNull File zippedFile) {
        Intrinsics.checkNotNullParameter((Object)zippedFile, (String)"zippedFile");
        CloseableHttpClient httpclient = HttpClients.createSystem();
        HttpPut httpPut = new HttpPut(this.url);
        httpPut.setEntity((HttpEntity)new FileEntity(zippedFile));
        httpPut.addHeader("Authorization", "Post-Api-Key " + this.postApiKey);
        httpPut.addHeader("Content-Type", "application/zip; charset=utf-8");
        Log.INSTANCE.info("Executing request " + httpPut.getRequestLine());
        ResponseHandler responseHandler = FileUploader::uploadFile$lambda-0;
        while (true) {
            try {
                String responseBody = (String)httpclient.execute((HttpUriRequest)httpPut, responseHandler);
                Log.INSTANCE.info("Request succeeded with response body " + responseBody);
                return;
            }
            catch (HttpResponseException e) {
                int n = e.getStatusCode();
                boolean bl = 500 <= n ? n < 600 : false;
                if (bl) {
                    Log.INSTANCE.debug("Request failed with status code " + e.getStatusCode() + ". Retrying...");
                    ++this.retryCount;
                    continue;
                }
                throw e;
                if (this.retryCount < 3) continue;
                return;
            }
            break;
        }
    }

    private static final String uploadFile$lambda-0(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (!(200 <= status ? status < 300 : false)) {
            throw new HttpResponseException(status, "Unexpected response status " + status + " " + body);
        }
        return body;
    }
}

