/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common;

import io.appmetrica.analytics.gradle.common.AGPVersion;
import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.MappingType;
import io.appmetrica.analytics.gradle.common.PluginConfigurator;
import io.appmetrica.analytics.gradle.common.UtilsKt;
import io.appmetrica.analytics.gradle.common.api.AndroidApplicationVariant;
import io.appmetrica.analytics.gradle.common.config.AppMetricaPluginConfig;
import io.appmetrica.analytics.gradle.common.tasks.CheckDependenciesTask;
import io.appmetrica.analytics.gradle.common.tasks.GenerateSymbolsTask;
import io.appmetrica.analytics.gradle.common.tasks.ResourcesGeneratorTask;
import io.appmetrica.analytics.gradle.common.tasks.UploadTask;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006 "}, d2={"Lio/appmetrica/analytics/gradle/common/PluginConfigurator;", "", "()V", "configure", "", "project", "Lorg/gradle/api/Project;", "variant", "Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;", "config", "Lio/appmetrica/analytics/gradle/common/config/AppMetricaPluginConfig;", "configureCommon", "configureNdk", "getOrCreateCheckDependenciesTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/appmetrica/analytics/gradle/common/tasks/CheckDependenciesTask;", "getOrCreateGenerateSymbolsTask", "Lio/appmetrica/analytics/gradle/common/tasks/GenerateSymbolsTask;", "getOrCreateResourceTask", "Lio/appmetrica/analytics/gradle/common/tasks/ResourcesGeneratorTask;", "getOrCreateUploadMappingTask", "Lio/appmetrica/analytics/gradle/common/tasks/UploadTask;", "getOrCreateUploadNdkSymbolsTask", "getOrCreateZipFilesTask", "Lorg/gradle/api/tasks/bundling/Zip;", "getOrCreateZipNdkFilesTask", "getParamsForAnalytics", "", "", "appMetricaBuildDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "common"})
public final class PluginConfigurator {
    public final void configure(@NotNull Project project, @NotNull AndroidApplicationVariant variant, @NotNull AppMetricaPluginConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (((Boolean)config.getEnable().invoke()).booleanValue()) {
            this.configureCommon(project, variant, config);
        }
        if (((Boolean)config.getNdk().getEnable().invoke()).booleanValue()) {
            this.configureNdk(project, variant, config);
        }
    }

    private final void configureCommon(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        Log.INSTANCE.info(StringsKt.trimIndent((String)("\n                Configuring " + variant.getName() + ":\n                    offline = " + config.getOffline().invoke() + " \n                    ndk.enable = " + config.getNdk().getEnable().invoke() + "\n            ")));
        TaskProvider<UploadTask> uploadTask = this.getOrCreateUploadMappingTask(project, variant, config);
        project.afterEvaluate(arg_0 -> PluginConfigurator.configureCommon$lambda-0(variant, uploadTask, arg_0));
    }

    private final void configureNdk(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        Log.INSTANCE.info("Configuring ndk " + variant.getName());
        if (((Boolean)config.getNdk().getAddNdkCrashesDependency().invoke()).booleanValue()) {
            project.getDependencies().add(variant.getName() + "Implementation", (Object)"io.appmetrica.analytics:analytics-ndk-crashes:3.0.0");
        }
        this.getOrCreateUploadNdkSymbolsTask(project, variant, config);
    }

    private final TaskProvider<CheckDependenciesTask> getOrCreateCheckDependenciesTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "check" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaDependencies";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<CheckDependenciesTask> taskProvider = UtilsKt.findNamed(taskContainer, taskName, CheckDependenciesTask.class);
        if (taskProvider != null) {
            TaskProvider<CheckDependenciesTask> it = taskProvider;
            boolean bl = false;
            return it;
        }
        TaskProvider taskProvider2 = project.getTasks().register(taskName, CheckDependenciesTask.class, arg_0 -> PluginConfigurator.getOrCreateCheckDependenciesTask$lambda-3(project, variant, this, config, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.register(t\u2026oAppMetricas())\n        }");
        return taskProvider2;
    }

    private final TaskProvider<UploadTask> getOrCreateUploadMappingTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "upload" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaMapping";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<UploadTask> taskProvider = UtilsKt.findNamed(taskContainer, taskName, UploadTask.class);
        if (taskProvider != null) {
            TaskProvider<UploadTask> it = taskProvider;
            boolean bl = false;
            return it;
        }
        TaskProvider<Zip> zipFilesTask = this.getOrCreateZipFilesTask(project, variant, config);
        TaskProvider<CheckDependenciesTask> checkDependenciesTask = this.getOrCreateCheckDependenciesTask(project, variant, config);
        TaskProvider taskProvider2 = project.getTasks().register(taskName, UploadTask.class, arg_0 -> PluginConfigurator.getOrCreateUploadMappingTask$lambda-6(zipFilesTask, config, this, project, variant, checkDependenciesTask, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.register(t\u2026pendenciesTask)\n        }");
        return taskProvider2;
    }

    private final TaskProvider<Zip> getOrCreateZipFilesTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "zip" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaFiles";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<Zip> taskProvider = UtilsKt.findNamed(taskContainer, taskName, Zip.class);
        if (taskProvider != null) {
            TaskProvider<Zip> it = taskProvider;
            boolean bl = false;
            return it;
        }
        TaskProvider<ResourcesGeneratorTask> resCreationTask = this.getOrCreateResourceTask(project, variant, config);
        Provider mappingFileProvider = config.getMappingFile().invoke() == null ? variant.getMappingFile() : project.provider(() -> PluginConfigurator.getOrCreateZipFilesTask$lambda-8(config, variant));
        TaskProvider taskProvider2 = project.getTasks().register(taskName, Zip.class, arg_0 -> PluginConfigurator.getOrCreateZipFilesTask$lambda-11(resCreationTask, mappingFileProvider, this, project, variant, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.register(t\u2026ir(\"result\") })\n        }");
        return taskProvider2;
    }

    private final TaskProvider<UploadTask> getOrCreateUploadNdkSymbolsTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "upload" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaNdkSymbols";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<UploadTask> taskProvider = UtilsKt.findNamed(taskContainer, taskName, UploadTask.class);
        if (taskProvider != null) {
            TaskProvider<UploadTask> it = taskProvider;
            boolean bl = false;
            return it;
        }
        TaskProvider<Zip> zipFilesTask = this.getOrCreateZipNdkFilesTask(project, variant, config);
        TaskProvider taskProvider2 = project.getTasks().register(taskName, UploadTask.class, arg_0 -> PluginConfigurator.getOrCreateUploadNdkSymbolsTask$lambda-14(config, zipFilesTask, this, project, variant, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.register(t\u2026ariant, config)\n        }");
        return taskProvider2;
    }

    private final TaskProvider<Zip> getOrCreateZipNdkFilesTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "zip" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaNdkFiles";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<Zip> taskProvider = UtilsKt.findNamed(taskContainer, taskName, Zip.class);
        if (taskProvider != null) {
            TaskProvider<Zip> it = taskProvider;
            boolean bl = false;
            return it;
        }
        TaskProvider<ResourcesGeneratorTask> resCreationTask = this.getOrCreateResourceTask(project, variant, config);
        TaskProvider<GenerateSymbolsTask> generateSymbolsTask = this.getOrCreateGenerateSymbolsTask(project, variant, config);
        TaskProvider taskProvider2 = project.getTasks().register(taskName, Zip.class, arg_0 -> PluginConfigurator.getOrCreateZipNdkFilesTask$lambda-19(resCreationTask, generateSymbolsTask, this, project, variant, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.register(t\u2026ir(\"result\") })\n        }");
        return taskProvider2;
    }

    private final TaskProvider<GenerateSymbolsTask> getOrCreateGenerateSymbolsTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "generate" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaNdkSymbols";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<GenerateSymbolsTask> taskProvider = UtilsKt.findNamed(taskContainer, taskName, GenerateSymbolsTask.class);
        if (taskProvider != null) {
            TaskProvider<GenerateSymbolsTask> it = taskProvider;
            boolean bl = false;
            return it;
        }
        Provider soFilesProvider = variant.getDefaultSoFiles().map(arg_0 -> PluginConfigurator.getOrCreateGenerateSymbolsTask$lambda-21(config, arg_0));
        TaskProvider taskProvider2 = project.getTasks().register(taskName, GenerateSymbolsTask.class, arg_0 -> PluginConfigurator.getOrCreateGenerateSymbolsTask$lambda-23(soFilesProvider, this, project, variant, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.register(t\u2026r(\"symbols\") })\n        }");
        return taskProvider2;
    }

    private final TaskProvider<ResourcesGeneratorTask> getOrCreateResourceTask(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        String taskName = "create" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaRes";
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskProvider<ResourcesGeneratorTask> taskProvider = UtilsKt.findNamed(taskContainer, taskName, ResourcesGeneratorTask.class);
        if (taskProvider != null) {
            TaskProvider<ResourcesGeneratorTask> it = taskProvider;
            boolean bl = false;
            return it;
        }
        TaskProvider taskProvider2 = project.getTasks().register(taskName, ResourcesGeneratorTask.class, arg_0 -> PluginConfigurator.getOrCreateResourceTask$lambda-27(variant, project, config, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"taskProvider");
        variant.addGenerateResourceTask((TaskProvider<? extends DefaultTask>)taskProvider2, (Function1<? super DefaultTask, ? extends DirectoryProperty>)((Function1)getOrCreateResourceTask.2.INSTANCE));
        return taskProvider2;
    }

    private final Map<String, Object> getParamsForAnalytics(Project project, AndroidApplicationVariant variant, AppMetricaPluginConfig config) {
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"offline", (Object)config.getOffline().invoke());
        pairArray[1] = TuplesKt.to((Object)"ndk.enable", (Object)config.getNdk().getEnable().invoke());
        String string = (String)variant.getVersionName().getOrNull();
        if (string == null) {
            string = "";
        }
        pairArray[2] = TuplesKt.to((Object)"versionName", (Object)string);
        Integer n = (Integer)variant.getVersionCode().getOrNull();
        if (n == null) {
            n = 0;
        }
        pairArray[3] = TuplesKt.to((Object)"versionCode", (Object)n);
        pairArray[4] = TuplesKt.to((Object)"applicationId", (Object)variant.getApplicationId());
        pairArray[5] = TuplesKt.to((Object)"agp.version", (Object)AGPVersion.INSTANCE.current(project).toString());
        pairArray[6] = TuplesKt.to((Object)"gradle.version", (Object)GradleVersion.current().getVersion());
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Provider<Directory> appMetricaBuildDir(Project $this$appMetricaBuildDir, AndroidApplicationVariant variant) {
        Provider provider = $this$appMetricaBuildDir.getLayout().getBuildDirectory().dir("appmetrica/" + variant.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"layout.buildDirectory.di\u2026metrica/${variant.name}\")");
        return provider;
    }

    private static final void configureCommon$lambda-0(AndroidApplicationVariant $variant, TaskProvider $uploadTask, Project it) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$uploadTask, (String)"$uploadTask");
        $variant.subscribeOnAssembleTask((TaskProvider<? extends DefaultTask>)$uploadTask);
    }

    private static final RegularFile getOrCreateCheckDependenciesTask$lambda-3$lambda-2(Directory it) {
        return it.file("report.txt");
    }

    private static final void getOrCreateCheckDependenciesTask$lambda-3(Project $project, AndroidApplicationVariant $variant, PluginConfigurator this$0, AppMetricaPluginConfig $config, CheckDependenciesTask task) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        task.getRootComponent().set($project.getConfigurations().getByName($variant.getName() + "RuntimeClasspath").getIncoming().getResolutionResult().getRootComponent());
        task.getOutputFile().set(this$0.appMetricaBuildDir($project, $variant).map(PluginConfigurator::getOrCreateCheckDependenciesTask$lambda-3$lambda-2));
        task.getAllowTwoAppMetricas().set($config.getAllowTwoAppMetricas().invoke());
    }

    private static final Provider getOrCreateUploadMappingTask$lambda-6$lambda-5(Zip it) {
        return it.getArchiveFile();
    }

    private static final void getOrCreateUploadMappingTask$lambda-6(TaskProvider $zipFilesTask, AppMetricaPluginConfig $config, PluginConfigurator this$0, Project $project, AndroidApplicationVariant $variant, TaskProvider $checkDependenciesTask, UploadTask task) {
        Intrinsics.checkNotNullParameter((Object)$zipFilesTask, (String)"$zipFilesTask");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$checkDependenciesTask, (String)"$checkDependenciesTask");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        task.getZipFile().set($zipFilesTask.flatMap(PluginConfigurator::getOrCreateUploadMappingTask$lambda-6$lambda-5));
        task.setUploadUrl("https://api.appmetrica.yandex.ru/management/v1/application/crash/proguard/upload");
        task.setPostApiKey((String)$config.getPostApiKey().invoke());
        task.setOffline((Boolean)$config.getOffline().invoke());
        task.setEnableAnalytics($config.getEnableAnalytics());
        task.setParamsForAnalytics(MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"task_type", (Object)"upload_mapping")), this$0.getParamsForAnalytics($project, $variant, $config)));
        Object[] objectArray = new Object[]{$checkDependenciesTask};
        task.dependsOn(objectArray);
    }

    private static final File getOrCreateZipFilesTask$lambda-8(AppMetricaPluginConfig $config, AndroidApplicationVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        File file = (File)$config.getMappingFile().invoke();
        if (file == null) {
            throw new IllegalStateException("Minify is not enabled for variant " + $variant.getName() + ".");
        }
        return file;
    }

    private static final Provider getOrCreateZipFilesTask$lambda-11$lambda-9(ResourcesGeneratorTask it) {
        return (Provider)it.getBuildInfoFile();
    }

    private static final Directory getOrCreateZipFilesTask$lambda-11$lambda-10(Directory it) {
        return it.dir("result");
    }

    private static final void getOrCreateZipFilesTask$lambda-11(TaskProvider $resCreationTask, Provider $mappingFileProvider, PluginConfigurator this$0, Project $project, AndroidApplicationVariant $variant, Zip task) {
        Intrinsics.checkNotNullParameter((Object)$resCreationTask, (String)"$resCreationTask");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        Object[] objectArray = new Object[]{$resCreationTask.flatMap(PluginConfigurator::getOrCreateZipFilesTask$lambda-11$lambda-9)};
        task.from(objectArray);
        objectArray = new Object[]{$mappingFileProvider};
        task.from(objectArray);
        task.getArchiveFileName().set((Object)"mapping.zip");
        task.getDestinationDirectory().set(this$0.appMetricaBuildDir($project, $variant).map(PluginConfigurator::getOrCreateZipFilesTask$lambda-11$lambda-10));
    }

    private static final Provider getOrCreateUploadNdkSymbolsTask$lambda-14$lambda-13(Zip it) {
        return it.getArchiveFile();
    }

    private static final void getOrCreateUploadNdkSymbolsTask$lambda-14(AppMetricaPluginConfig $config, TaskProvider $zipFilesTask, PluginConfigurator this$0, Project $project, AndroidApplicationVariant $variant, UploadTask task) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$zipFilesTask, (String)"$zipFilesTask");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        task.setUploadUrl("https://api.appmetrica.yandex.ru/management/v1/application/crash/android_native/upload");
        task.setPostApiKey((String)$config.getPostApiKey().invoke());
        task.setOffline((Boolean)$config.getOffline().invoke());
        task.getZipFile().set($zipFilesTask.flatMap(PluginConfigurator::getOrCreateUploadNdkSymbolsTask$lambda-14$lambda-13));
        task.setEnableAnalytics($config.getEnableAnalytics());
        task.setParamsForAnalytics(MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"task_type", (Object)"upload_ndk")), this$0.getParamsForAnalytics($project, $variant, $config)));
    }

    private static final Provider getOrCreateZipNdkFilesTask$lambda-19$lambda-16(ResourcesGeneratorTask it) {
        return (Provider)it.getBuildInfoFile();
    }

    private static final Provider getOrCreateZipNdkFilesTask$lambda-19$lambda-17(GenerateSymbolsTask it) {
        return (Provider)it.getSymbolsDir();
    }

    private static final Directory getOrCreateZipNdkFilesTask$lambda-19$lambda-18(Directory it) {
        return it.dir("result");
    }

    private static final void getOrCreateZipNdkFilesTask$lambda-19(TaskProvider $resCreationTask, TaskProvider $generateSymbolsTask, PluginConfigurator this$0, Project $project, AndroidApplicationVariant $variant, Zip task) {
        Intrinsics.checkNotNullParameter((Object)$resCreationTask, (String)"$resCreationTask");
        Intrinsics.checkNotNullParameter((Object)$generateSymbolsTask, (String)"$generateSymbolsTask");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        Object[] objectArray = new Object[]{$resCreationTask.flatMap(PluginConfigurator::getOrCreateZipNdkFilesTask$lambda-19$lambda-16)};
        task.from(objectArray);
        objectArray = new Object[]{$generateSymbolsTask.flatMap(PluginConfigurator::getOrCreateZipNdkFilesTask$lambda-19$lambda-17)};
        task.from(objectArray);
        task.getArchiveFileName().set((Object)"symbols.zip");
        task.getDestinationDirectory().set(this$0.appMetricaBuildDir($project, $variant).map(PluginConfigurator::getOrCreateZipNdkFilesTask$lambda-19$lambda-18));
    }

    private static final Set getOrCreateGenerateSymbolsTask$lambda-21(AppMetricaPluginConfig $config, Set it) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        if (((List)$config.getNdk().getSoFiles().invoke()).isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            set = SetsKt.plus((Set)it, (Iterable)CollectionsKt.toSet((Iterable)((Iterable)$config.getNdk().getAdditionalSoFiles().invoke())));
        } else {
            set = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)$config.getNdk().getSoFiles().invoke())), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)$config.getNdk().getAdditionalSoFiles().invoke())));
        }
        return set;
    }

    private static final Directory getOrCreateGenerateSymbolsTask$lambda-23$lambda-22(Directory it) {
        return it.dir("symbols");
    }

    private static final void getOrCreateGenerateSymbolsTask$lambda-23(Provider $soFilesProvider, PluginConfigurator this$0, Project $project, AndroidApplicationVariant $variant, GenerateSymbolsTask task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        Object[] objectArray = new Object[]{$soFilesProvider};
        task.getFiles().from(objectArray);
        task.getSymbolsDir().set(this$0.appMetricaBuildDir($project, $variant).map(PluginConfigurator::getOrCreateGenerateSymbolsTask$lambda-23$lambda-22));
    }

    private static final RegularFile getOrCreateResourceTask$lambda-27$lambda-25(Directory it) {
        return it.file("info.txt");
    }

    private static final Directory getOrCreateResourceTask$lambda-27$lambda-26(Directory it) {
        return it.dir("res");
    }

    private static final void getOrCreateResourceTask$lambda-27(AndroidApplicationVariant $variant, Project $project, AppMetricaPluginConfig $config, PluginConfigurator this$0, ResourcesGeneratorTask task) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        task.notCompatibleWithConfigurationCache("Not supported in current version");
        task.getVersionName().set($variant.getVersionName());
        task.getVersionCode().set($variant.getVersionCode());
        Property<MappingType> property = task.getMappingType();
        Object object = $project.getProperties().get("android.enableR8");
        if (object == null) {
            object = "false";
        }
        property.set((Object)(Boolean.parseBoolean((String)object) ? MappingType.R8 : MappingType.PROGUARD));
        task.getSplitVersionCodes().set($variant.getSplitVersionCodes());
        task.getOffline().set($config.getOffline().invoke());
        task.getNdkEnable().set($config.getNdk().getEnable().invoke());
        task.getBuildInfoFile().set(this$0.appMetricaBuildDir($project, $variant).map(PluginConfigurator::getOrCreateResourceTask$lambda-27$lambda-25));
        task.getResDirectory().set(this$0.appMetricaBuildDir($project, $variant).map(PluginConfigurator::getOrCreateResourceTask$lambda-27$lambda-26));
    }
}

