/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.ndk.YSym;
import io.appmetrica.analytics.gradle.common.ndk.YSymException;
import io.appmetrica.analytics.gradle.common.ndk.YSymFactory;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.range.NamedRanges;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineData;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineEntry;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfHandler;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfMachine;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfParserKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSymbol;
import io.appmetrica.analytics.gradle.common.ndk.io.StringUtilsKt;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/ElfYSymFactory;", "Lio/appmetrica/analytics/gradle/common/ndk/YSymFactory;", "()V", "createCSymFromFile", "Lio/appmetrica/analytics/gradle/common/ndk/YSym;", "binFile", "Ljava/io/File;", "YSymFactoryHandler", "common"})
public final class ElfYSymFactory
implements YSymFactory {
    @Override
    @NotNull
    public YSym createCSymFromFile(@NotNull File binFile) throws YSymException, IOException {
        Intrinsics.checkNotNullParameter((Object)binFile, (String)"binFile");
        Log.INSTANCE.debug("Processing file " + binFile.getAbsolutePath());
        if (!binFile.isFile()) {
            throw new IllegalArgumentException("Invalid object file: " + binFile);
        }
        YSymFactoryHandler handler = new YSymFactoryHandler();
        ElfParserKt.parseElf(binFile, (ElfHandler)handler);
        return handler.getBuilder().build();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u001c\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\u0016\u0010(\u001a\u00020\u0006*\u00020)2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\f\u0010(\u001a\u00020\u0006*\u00020\u001cH\u0002J\f\u0010,\u001a\u00020\u0006*\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/ElfYSymFactory$YSymFactoryHandler;", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfHandler;", "()V", "arch", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfMachine;", "archName", "", "<set-?>", "Lio/appmetrica/analytics/gradle/common/ndk/YSym$Builder;", "builder", "getBuilder", "()Lio/appmetrica/analytics/gradle/common/ndk/YSym$Builder;", "codeId", "hasDebugInfo", "", "identifier", "isArm", "endProcessingSymbols", "", "processArmVersion", "armVersion", "processDebugInfoCompilationUnit", "debugInfoCompilationUnits", "", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitContext;", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineData;", "processElfBuildId", "byteArray", "", "processElfHeader", "fileHeader", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileHeader;", "processElfSymbols", "elfSymbols", "", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSymbol;", "processSectionHeaders", "sectionHeaders", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeaders;", "startProcessingSymbols", "toHexString", "", "size", "", "toUuidString", "common"})
    private static final class YSymFactoryHandler
    implements ElfHandler {
        private YSym.Builder builder;
        private ElfMachine arch;
        private String archName;
        private boolean isArm;
        private boolean hasDebugInfo;
        private String identifier;
        private String codeId;

        @NotNull
        public final YSym.Builder getBuilder() {
            YSym.Builder builder = this.builder;
            if (builder != null) {
                return builder;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            return null;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void processElfHeader(@NotNull ElfFileHeader fileHeader) {
            Intrinsics.checkNotNullParameter((Object)fileHeader, (String)"fileHeader");
            Log.INSTANCE.debug("Processing elf file header : " + StringUtilsKt.toPrettyString(fileHeader));
            this.arch = fileHeader.getMachine();
            v0 = this.arch;
            if (v0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arch");
                v0 = null;
            }
            if (v0 == ElfMachine.EM_ARM) ** GOTO lbl-1000
            v1 = this.arch;
            if (v1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arch");
                v1 = null;
            }
            if (v1 == ElfMachine.EM_AARCH64) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.isArm = v2;
            this.archName = fileHeader.getMachine().getArchName();
        }

        @Override
        public void processSectionHeaders(@NotNull ElfSectionHeaders sectionHeaders) {
            Intrinsics.checkNotNullParameter((Object)sectionHeaders, (String)"sectionHeaders");
            Log.INSTANCE.debug("Processing section headers");
            StringUtilsKt.print(sectionHeaders, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)Log.INSTANCE){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((Log)this.receiver).debug(p0);
                }
            }));
            this.hasDebugInfo = sectionHeaders.hasDebugInfo();
        }

        @Override
        public void processElfBuildId(@Nullable byte[] byteArray) {
            if (byteArray == null) {
                throw new YSymException("Not found ELF build id");
            }
            Log.INSTANCE.debug("Processing elf build id : " + StringUtilsKt.toPrettyString(byteArray));
            this.identifier = this.toUuidString(byteArray) + "0";
            String string = this.identifier;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"identifier");
                string = null;
            }
            Log.INSTANCE.debug("UUID: " + string);
            this.codeId = this.toHexString(byteArray);
            String string2 = this.codeId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeId");
                string2 = null;
            }
            Log.INSTANCE.debug("Code id: " + string2);
        }

        @Override
        public void processArmVersion(@NotNull String armVersion) {
            Intrinsics.checkNotNullParameter((Object)armVersion, (String)"armVersion");
            Log.INSTANCE.debug("Processing elf arm version : " + armVersion);
            ElfMachine elfMachine = this.arch;
            if (elfMachine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arch");
                elfMachine = null;
            }
            if (elfMachine == ElfMachine.EM_ARM) {
                String string = this.archName;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"archName");
                    string = null;
                }
                this.archName = string + "v" + armVersion;
            }
        }

        @Override
        public void startProcessingSymbols() {
            String string;
            String string2;
            String generationLog = this.hasDebugInfo ? "using ELF symbols and DWARF elfData for ySYM generation." : "using ELF elfData for ySYM generation.";
            Log.INSTANCE.debug(StringsKt.trimIndent((String)("\n                    =================================================================================\n                    Start processing symbols " + generationLog + "\n                    =================================================================================\n                ")));
            String string3 = this.identifier;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"identifier");
                string3 = null;
            }
            if ((string2 = this.codeId) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeId");
                string2 = null;
            }
            if ((string = this.archName) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"archName");
                string = null;
            }
            this.builder = new YSym.Builder(string3, string2, string);
        }

        @Override
        public void processElfSymbols(@NotNull List<ElfSymbol> elfSymbols) {
            Intrinsics.checkNotNullParameter(elfSymbols, (String)"elfSymbols");
            Log.INSTANCE.debug("Processing elf symbols");
            StringUtilsKt.print(elfSymbols, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)Log.INSTANCE){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((Log)this.receiver).debug(p0);
                }
            }));
            Iterable $this$forEach$iv = elfSymbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ElfSymbol it = (ElfSymbol)element$iv;
                boolean bl = false;
                this.getBuilder().addSymbol(it);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processDebugInfoCompilationUnit(@NotNull Map<CompilationUnitContext, DebugLineData> debugInfoCompilationUnits) {
            Intrinsics.checkNotNullParameter(debugInfoCompilationUnits, (String)"debugInfoCompilationUnits");
            Log.INSTANCE.debug("Processing debug info compilation units");
            Map<CompilationUnitContext, DebugLineData> $this$forEach$iv = debugInfoCompilationUnits;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<CompilationUnitContext, DebugLineData>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                List list;
                Iterable $this$map$iv;
                Iterable it;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Map.Entry<CompilationUnitContext, DebugLineData> element$iv;
                Map.Entry<CompilationUnitContext, DebugLineData> entry = element$iv = iterator.next();
                boolean bl = false;
                CompilationUnitContext context = entry.getKey();
                DebugLineData debugLineData = entry.getValue();
                Log.INSTANCE.debug("Processing debug info compilation unit : " + context.getName());
                Iterable iterable = context.getSubPrograms();
                Object object = Log.INSTANCE;
                boolean $i$f$map = false;
                void var13_14 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    YSym.SubProgram subProgram = (YSym.SubProgram)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((YSym.SubProgram)((Object)it)).getName().getSymbolName());
                }
                ((Log)object).debug("Subprogram symbol names : " + StringUtilsKt.toPrettyString((List)destination$iv$iv));
                NamedRanges namedRanges = new NamedRanges(context.getNamedRanges());
                Object object2 = debugLineData.getDebugLineContext();
                if (object2 != null && (object2 = ((DebugLineContext)object2).getFiles()) != null) {
                    void $this$mapTo$iv$iv3;
                    $this$map$iv = (Iterable)object2;
                    boolean $i$f$map2 = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it2;
                        DebugLineContext.DebugLineFileInfo debugLineFileInfo = (DebugLineContext.DebugLineFileInfo)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl3 = false;
                        object.add(it2.getDirectory() + "/" + it2.getName());
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List files = list;
                Log.INSTANCE.debug("Debug line context file names : " + StringUtilsKt.toPrettyString(files));
                Iterable $this$map$iv3 = debugLineData.getDebugLineEntries();
                boolean $i$f$map3 = false;
                $this$map$iv = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    DebugLineEntry debugLineEntry = (DebugLineEntry)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl4 = false;
                    object.add(new YSym.Line(it3.getAddress(), it3.getFile(), it3.getLineNumber(), it3.getColumnNumber(), it3.getEndSequence()));
                }
                List lines = (List)destination$iv$iv3;
                this.getBuilder().addCompileUnit(new YSym.CompileUnit(context.getName(), context.getRanges(), files, lines, context.getSubPrograms()));
            }
        }

        @Override
        public void endProcessingSymbols() {
            Log.INSTANCE.debug("=================================================================================\nEnd processing symbols\n=================================================================================");
        }

        private final String toHexString(byte[] $this$toHexString) {
            return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<Byte, CharSequence>(this){
                final /* synthetic */ YSymFactoryHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(byte it) {
                    return YSymFactoryHandler.access$toHexString(this.this$0, it, 2);
                }
            }), (int)30, null);
        }

        private final String toHexString(byte $this$toHexString, int size) {
            String string = StringsKt.padStart((String)UStringsKt.toString-LxnNnR4((byte)UByte.constructor-impl((byte)$this$toHexString), (int)16), (int)size, (char)'0').toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
            return string;
        }

        static /* synthetic */ String toHexString$default(YSymFactoryHandler ySymFactoryHandler, byte by, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return ySymFactoryHandler.toHexString(by, n);
        }

        private final String toUuidString(byte[] $this$toUuidString) {
            byte[] bytes = $this$toUuidString;
            if (Intrinsics.areEqual((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.BIG_ENDIAN)) {
                return this.toHexString(bytes);
            }
            byte[] byArray = Arrays.copyOf(bytes, 16);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            byte[] extendedBytes = byArray;
            List answer = new ArrayList();
            CollectionsKt.addAll((Collection)answer, (Iterable)CollectionsKt.reversed((Iterable)ArraysKt.slice((byte[])extendedBytes, (IntRange)RangesKt.until((int)0, (int)4))));
            CollectionsKt.addAll((Collection)answer, (Iterable)CollectionsKt.reversed((Iterable)ArraysKt.slice((byte[])extendedBytes, (IntRange)RangesKt.until((int)4, (int)6))));
            CollectionsKt.addAll((Collection)answer, (Iterable)CollectionsKt.reversed((Iterable)ArraysKt.slice((byte[])extendedBytes, (IntRange)RangesKt.until((int)6, (int)8))));
            CollectionsKt.addAll((Collection)answer, (Iterable)ArraysKt.slice((byte[])extendedBytes, (IntRange)RangesKt.until((int)8, (int)16)));
            return this.toHexString(CollectionsKt.toByteArray((Collection)answer));
        }

        public static final /* synthetic */ String access$toHexString(YSymFactoryHandler $this, byte $receiver, int size) {
            return $this.toHexString($receiver, size);
        }
    }
}

