/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.info;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.ndk.YSym;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.DwarfException;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.FileContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DWTag;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DebugAbbrevAttribute;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DebugAbbrevEntry;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DebugAbbrevParserKt;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitHeader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitHeaderKt;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.processor.CompileUnitAttributeProcessor;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.processor.InlineSubroutineAttributeProcessor;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.processor.SubProgramAttributeProcessor;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader.DebugAttributesReader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader.SkipAttributesReader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.range.NamedRangesResolver;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u001aH\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u001a4\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002\u001a.\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u001a6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00012\u0006\u0010\u000b\u001a\u00020\tH\u0002\u001a.\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u001aI\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u001c0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010!\u001a&\u0010\"\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0002\u00a8\u0006$"}, d2={"parseChildEntries", "", "Lio/appmetrica/analytics/gradle/common/ndk/YSym$SubProgram;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "context", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitContext;", "abbrevEntries", "", "", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/abbrev/DebugAbbrevEntry;", "depth", "subProgram", "parseCompilationUnit", "fileContext", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/FileContext;", "header", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitHeader;", "parseCompilationUnitEntry", "attributes", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/abbrev/DebugAbbrevAttribute;", "parseDebugInfo", "parseInline", "Lio/appmetrica/analytics/gradle/common/ndk/YSym$Inline;", "entryOffset", "", "parseSubProgram", "resolveRanges", "Lkotlin/Pair;", "addressSize", "rangesSectionOffset", "offset", "baseAddress", "(Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;IJLjava/lang/Long;J)Ljava/util/List;", "skip", "", "common"})
public final class DebugInfoParserKt {
    @NotNull
    public static final List<CompilationUnitContext> parseDebugInfo(@NotNull ByteReader reader, @NotNull FileContext fileContext) throws IOException, DwarfException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)fileContext, (String)"fileContext");
        ElfSectionHeader debugInfoHeader = fileContext.getDebugHeaders().getDebugInfo();
        reader.seek(debugInfoHeader.getOffset());
        long sectionEndOffset = debugInfoHeader.getOffset() + debugInfoHeader.getSize();
        List compilationUnitContexts = new ArrayList();
        while (reader.getCurrentOffset() != sectionEndOffset) {
            compilationUnitContexts.add(DebugInfoParserKt.parseCompilationUnit(reader, fileContext));
        }
        return compilationUnitContexts;
    }

    @NotNull
    public static final CompilationUnitContext parseCompilationUnit(@NotNull ByteReader reader, @NotNull FileContext fileContext) throws IOException, DwarfException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)fileContext, (String)"fileContext");
        CompilationUnitHeader header = CompilationUnitHeaderKt.readCompilationUnitHeader(reader, fileContext.getDebugHeaders().getDebugInfo().getOffset());
        long debugAbbrevOffset = fileContext.getDebugHeaders().getDebugAbbrev().getOffset() + header.getAbbrevOffset();
        return DebugInfoParserKt.parseCompilationUnit(reader, fileContext, header, DebugAbbrevParserKt.parseAbbrevSection(reader, debugAbbrevOffset));
    }

    private static final CompilationUnitContext parseCompilationUnit(ByteReader reader, FileContext fileContext, CompilationUnitHeader header, Map<Integer, DebugAbbrevEntry> abbrevEntries) throws IOException, DwarfException {
        int abbrevCode = reader.readULEB128();
        Map<Integer, DebugAbbrevEntry> map = abbrevEntries;
        DebugAbbrevEntry debugAbbrevEntry = map.get(abbrevCode);
        if (debugAbbrevEntry == null) {
            boolean bl = false;
            throw new DwarfException("Unrecognized abbreviations code: " + abbrevCode);
        }
        DebugAbbrevEntry abbrevEntry = debugAbbrevEntry;
        CompilationUnitContext context = DebugInfoParserKt.parseCompilationUnitEntry(reader, fileContext, header, abbrevEntry.getAttributes());
        if (abbrevEntry.getHasChildren()) {
            context.getSubPrograms().addAll(DebugInfoParserKt.parseChildEntries$default(reader, context, abbrevEntries, 0, null, 24, null));
        }
        return context;
    }

    private static final List<YSym.SubProgram> parseChildEntries(ByteReader reader, CompilationUnitContext context, Map<Integer, DebugAbbrevEntry> abbrevEntries, int depth, YSym.SubProgram subProgram) throws IOException, DwarfException {
        List subPrograms = new ArrayList();
        long debugInfoOffset = context.getFileContext().getDebugHeaders().getDebugInfo().getOffset();
        int abbrevCode = 0;
        long entryOffset = 0L;
        block4: while (true) {
            DebugAbbrevEntry abbrevEntry;
            boolean bl = false;
            entryOffset = reader.getCurrentOffset() - debugInfoOffset;
            abbrevCode = reader.readULEB128();
            if (!(abbrevCode > 0)) break;
            Map<Integer, DebugAbbrevEntry> map = abbrevEntries;
            if (map.get(abbrevCode) == null) {
                boolean bl2 = false;
                throw new DwarfException("Unrecognized abbreviations code: " + abbrevCode);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[abbrevEntry.getTag().ordinal()]) {
                case 1: {
                    YSym.SubProgram curSubProgram = DebugInfoParserKt.parseSubProgram(reader, context, entryOffset, abbrevEntry.getAttributes());
                    subPrograms.add(curSubProgram);
                    if (!abbrevEntry.getHasChildren()) continue block4;
                    subPrograms.addAll((Collection)DebugInfoParserKt.parseChildEntries(reader, context, abbrevEntries, 1, curSubProgram));
                    continue block4;
                }
                case 2: {
                    YSym.Inline inline = DebugInfoParserKt.parseInline(reader, context, entryOffset, abbrevEntry.getAttributes(), depth);
                    YSym.SubProgram subProgram2 = subProgram;
                    if (subProgram2 != null) {
                        subProgram2.addInline(inline);
                    }
                    if (!abbrevEntry.getHasChildren()) continue block4;
                    subPrograms.addAll((Collection)DebugInfoParserKt.parseChildEntries(reader, context, abbrevEntries, depth + 1, subProgram));
                    continue block4;
                }
            }
            DebugInfoParserKt.skip(reader, context, abbrevEntry.getAttributes());
            if (!abbrevEntry.getHasChildren()) continue;
            subPrograms.addAll((Collection)DebugInfoParserKt.parseChildEntries(reader, context, abbrevEntries, depth, subProgram));
        }
        return subPrograms;
    }

    static /* synthetic */ List parseChildEntries$default(ByteReader byteReader, CompilationUnitContext compilationUnitContext, Map map, int n, YSym.SubProgram subProgram, int n2, Object object) throws IOException, DwarfException {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            subProgram = null;
        }
        return DebugInfoParserKt.parseChildEntries(byteReader, compilationUnitContext, map, n, subProgram);
    }

    private static final YSym.SubProgram parseSubProgram(ByteReader reader, CompilationUnitContext context, long entryOffset, List<DebugAbbrevAttribute> attributes) throws IOException {
        int n = context.getHeader().getAddressSize();
        ElfSectionHeader elfSectionHeader = context.getFileContext().getDebugHeaders().getDebugRanges();
        Intrinsics.checkNotNull((Object)elfSectionHeader);
        NamedRangesResolver namedRangesResolver = new NamedRangesResolver(reader, n, elfSectionHeader.getOffset());
        SubProgramAttributeProcessor attributeProcessor = new SubProgramAttributeProcessor(entryOffset, context, namedRangesResolver);
        DebugAttributesReader attributesReader = new DebugAttributesReader(reader, context.getHeader(), context.getFileContext().getReferenceBytesConverter(), attributeProcessor, context.getFileContext().getDebugHeaders().getDebugStr().getOffset());
        return (YSym.SubProgram)attributesReader.readAttributes(attributes);
    }

    private static final YSym.Inline parseInline(ByteReader reader, CompilationUnitContext context, long entryOffset, List<DebugAbbrevAttribute> attributes, int depth) {
        int n = context.getHeader().getAddressSize();
        ElfSectionHeader elfSectionHeader = context.getFileContext().getDebugHeaders().getDebugRanges();
        Intrinsics.checkNotNull((Object)elfSectionHeader);
        NamedRangesResolver namedRangesResolver = new NamedRangesResolver(reader, n, elfSectionHeader.getOffset());
        InlineSubroutineAttributeProcessor attributeProcessor = new InlineSubroutineAttributeProcessor(entryOffset, context, namedRangesResolver, depth);
        DebugAttributesReader attributesReader = new DebugAttributesReader(reader, context.getHeader(), context.getFileContext().getReferenceBytesConverter(), attributeProcessor, context.getFileContext().getDebugHeaders().getDebugStr().getOffset());
        return (YSym.Inline)attributesReader.readAttributes(attributes);
    }

    private static final void skip(ByteReader reader, CompilationUnitContext context, List<DebugAbbrevAttribute> attributes) {
        new SkipAttributesReader(reader, context.getHeader()).readAttributes(attributes);
    }

    private static final CompilationUnitContext parseCompilationUnitEntry(ByteReader reader, FileContext fileContext, CompilationUnitHeader header, List<DebugAbbrevAttribute> attributes) throws IOException {
        Object object;
        CompilationUnitContext.EntryData entryData;
        block3: {
            block2: {
                CompileUnitAttributeProcessor attributeProcessor = new CompileUnitAttributeProcessor(fileContext.getReferenceBytesConverter());
                DebugAttributesReader attributesReader = new DebugAttributesReader(reader, header, fileContext.getReferenceBytesConverter(), attributeProcessor, fileContext.getDebugHeaders().getDebugStr().getOffset());
                entryData = (CompilationUnitContext.EntryData)attributesReader.readAttributes(attributes);
                object = entryData.getRangesSecOffset();
                if (object == null) break block2;
                long it = ((Number)object).longValue();
                boolean bl = false;
                int n = header.getAddressSize();
                ElfSectionHeader elfSectionHeader = fileContext.getDebugHeaders().getDebugRanges();
                Intrinsics.checkNotNull((Object)elfSectionHeader);
                List<Pair<Long, Long>> list = DebugInfoParserKt.resolveRanges(reader, n, elfSectionHeader.getOffset(), it, entryData.getLowPc());
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.listOf((Object)TuplesKt.to((Object)entryData.getLowPc(), (Object)entryData.getHighPc()));
        }
        List<Pair<Long, Long>> ranges = object;
        return new CompilationUnitContext(fileContext, header, entryData, ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Pair<Long, Long>> resolveRanges(ByteReader reader, int addressSize, long rangesSectionOffset, Long offset, long baseAddress) {
        if (offset == null) {
            return CollectionsKt.emptyList();
        }
        long originalOffset = reader.getCurrentOffset();
        List ranges = new ArrayList();
        try {
            reader.seek(rangesSectionOffset + offset);
            long currentBaseAddress = baseAddress;
            while (true) {
                long beginAddress = reader.readLong(addressSize);
                long endAddress = reader.readLong(addressSize);
                if (beginAddress == 0L && endAddress == 0L) {
                    break;
                }
                if (beginAddress == -1L) {
                    currentBaseAddress = endAddress;
                    continue;
                }
                ranges.add(TuplesKt.to((Object)(beginAddress += currentBaseAddress), (Object)(endAddress += currentBaseAddress)));
            }
        }
        catch (IOException e) {
            Log.INSTANCE.debug("Could not properly resolve range entries " + e);
        }
        finally {
            reader.seek(originalOffset);
        }
        return ranges;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DWTag.values().length];
            nArray[DWTag.SUBPROGRAM.ordinal()] = 1;
            nArray[DWTag.INLINED_SUBROUTINE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

