/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.processor;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.ReferenceBytesConverter;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DWAttribute;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DWForm;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.processor.AttributeProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0002H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/processor/CompileUnitAttributeProcessor;", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/processor/AttributeProcessor;", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitContext$EntryData;", "referenceBytesConverter", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/ReferenceBytesConverter;", "(Lio/appmetrica/analytics/gradle/common/ndk/dwarf/ReferenceBytesConverter;)V", "highPc", "", "isHighPcAddress", "", "lowPc", "name", "", "rangesSecOffset", "Ljava/lang/Long;", "stmtList", "finishProcessingAttributes", "processAttribute", "", "attribute", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/abbrev/DWAttribute;", "form", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/abbrev/DWForm;", "value", "", "common"})
public final class CompileUnitAttributeProcessor
implements AttributeProcessor<CompilationUnitContext.EntryData> {
    @NotNull
    private final ReferenceBytesConverter referenceBytesConverter;
    @NotNull
    private String name;
    private long lowPc;
    private long highPc;
    private boolean isHighPcAddress;
    private long stmtList;
    @Nullable
    private Long rangesSecOffset;

    public CompileUnitAttributeProcessor(@NotNull ReferenceBytesConverter referenceBytesConverter) {
        Intrinsics.checkNotNullParameter((Object)referenceBytesConverter, (String)"referenceBytesConverter");
        this.referenceBytesConverter = referenceBytesConverter;
        this.name = "";
        this.highPc = -1L;
    }

    @Override
    public void processAttribute(@NotNull DWAttribute attribute, @NotNull DWForm form, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)((Object)attribute), (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)((Object)form), (String)"form");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[attribute.ordinal()]) {
            case 1: {
                this.stmtList = this.referenceBytesConverter.asLongValue(value);
                break;
            }
            case 2: {
                this.highPc = this.referenceBytesConverter.asLongValue(value);
                this.isHighPcAddress = false;
            }
        }
    }

    @Override
    public void processAttribute(@NotNull DWAttribute attribute, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)attribute), (String)"attribute");
        switch (WhenMappings.$EnumSwitchMapping$0[attribute.ordinal()]) {
            case 3: {
                this.lowPc = value;
                break;
            }
            case 1: {
                this.stmtList = value;
                break;
            }
            case 4: {
                this.rangesSecOffset = value;
                break;
            }
            case 2: {
                this.highPc = value;
                this.isHighPcAddress = true;
            }
        }
    }

    @Override
    public void processAttribute(@NotNull DWAttribute attribute, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)attribute), (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (WhenMappings.$EnumSwitchMapping$0[attribute.ordinal()] == 5) {
            this.name = value;
        }
    }

    @Override
    @NotNull
    public CompilationUnitContext.EntryData finishProcessingAttributes() {
        if (!this.isHighPcAddress) {
            this.highPc += this.lowPc;
        }
        return new CompilationUnitContext.EntryData(this.name, this.rangesSecOffset, this.lowPc, this.highPc, this.stmtList);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DWAttribute.values().length];
            nArray[DWAttribute.STMT_LIST.ordinal()] = 1;
            nArray[DWAttribute.HIGH_PC.ordinal()] = 2;
            nArray[DWAttribute.LOW_PC.ordinal()] = 3;
            nArray[DWAttribute.RANGES.ordinal()] = 4;
            nArray[DWAttribute.NAME.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

