/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DWForm;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DebugAbbrevAttribute;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitHeader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader.AttributesReader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader.SkipAttributesReaderKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/reader/SkipAttributesReader;", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/reader/AttributesReader;", "", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "cuHeader", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitHeader;", "(Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitHeader;)V", "readAttributes", "attributes", "", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/abbrev/DebugAbbrevAttribute;", "skipDebugInfoEntryAttribute", "attribute", "common"})
public final class SkipAttributesReader
implements AttributesReader<Unit> {
    @NotNull
    private final ByteReader reader;
    @NotNull
    private final CompilationUnitHeader cuHeader;

    public SkipAttributesReader(@NotNull ByteReader reader, @NotNull CompilationUnitHeader cuHeader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)cuHeader, (String)"cuHeader");
        this.reader = reader;
        this.cuHeader = cuHeader;
    }

    @Override
    public void readAttributes(@NotNull List<DebugAbbrevAttribute> attributes) throws IOException {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Iterable $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugAbbrevAttribute it = (DebugAbbrevAttribute)element$iv;
            boolean bl = false;
            this.skipDebugInfoEntryAttribute(it);
        }
    }

    private final void skipDebugInfoEntryAttribute(DebugAbbrevAttribute attribute) throws IOException {
        switch (WhenMappings.$EnumSwitchMapping$0[attribute.getForm().ordinal()]) {
            case 1: {
                this.reader.readLong(this.cuHeader.getAddressSize());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.reader.readBytes(1);
                break;
            }
            case 5: 
            case 6: {
                this.reader.readBytes(2);
                break;
            }
            case 7: 
            case 8: {
                this.reader.readBytes(4);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.reader.readBytes(8);
                break;
            }
            case 12: 
            case 13: {
                this.reader.readULEB128();
                break;
            }
            case 14: {
                this.reader.readBytes(SkipAttributesReaderKt.access$getBytesCountForRefAddr(this.cuHeader));
                break;
            }
            case 15: 
            case 16: {
                this.reader.readBytes(this.cuHeader.getWordSize());
                break;
            }
            case 17: {
                this.reader.readBytesWithBlockSize(1);
                break;
            }
            case 18: {
                this.reader.readBytesWithBlockSize(2);
                break;
            }
            case 19: {
                this.reader.readBytesWithBlockSize(4);
                break;
            }
            case 20: 
            case 21: {
                this.reader.readBytesWithBlockSize();
                break;
            }
            case 22: {
                this.reader.readSLEB128();
                break;
            }
            case 23: {
                this.reader.readNullTerminatedString(Charsets.UTF_8);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DWForm.values().length];
            nArray[DWForm.ADDR.ordinal()] = 1;
            nArray[DWForm.FLAG.ordinal()] = 2;
            nArray[DWForm.DATA1.ordinal()] = 3;
            nArray[DWForm.REF1.ordinal()] = 4;
            nArray[DWForm.REF2.ordinal()] = 5;
            nArray[DWForm.DATA2.ordinal()] = 6;
            nArray[DWForm.REF4.ordinal()] = 7;
            nArray[DWForm.DATA4.ordinal()] = 8;
            nArray[DWForm.REF8.ordinal()] = 9;
            nArray[DWForm.DATA8.ordinal()] = 10;
            nArray[DWForm.REF_SIG8.ordinal()] = 11;
            nArray[DWForm.UDATA.ordinal()] = 12;
            nArray[DWForm.REF_UDATA.ordinal()] = 13;
            nArray[DWForm.REF_ADDR.ordinal()] = 14;
            nArray[DWForm.SEC_OFFSET.ordinal()] = 15;
            nArray[DWForm.STRP.ordinal()] = 16;
            nArray[DWForm.BLOCK1.ordinal()] = 17;
            nArray[DWForm.BLOCK2.ordinal()] = 18;
            nArray[DWForm.BLOCK4.ordinal()] = 19;
            nArray[DWForm.BLOCK.ordinal()] = 20;
            nArray[DWForm.EXPRLOC.ordinal()] = 21;
            nArray[DWForm.SDATA.ordinal()] = 22;
            nArray[DWForm.STRING.ordinal()] = 23;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

