/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.line;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineHeader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineRegisters;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ&\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0007R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineContext;", "", "header", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineHeader;", "registers", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineRegisters;", "offsetSize", "", "(Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineHeader;Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineRegisters;I)V", "directories", "", "", "getDirectories", "()Ljava/util/List;", "files", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineContext$DebugLineFileInfo;", "getFiles", "getHeader", "()Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineHeader;", "getOffsetSize", "()I", "getRegisters", "()Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineRegisters;", "defineDirectory", "", "directory", "defineFile", "fileName", "directoryIndex", "modTime", "length", "getFileInfo", "fileIndex", "DebugLineFileInfo", "common"})
public final class DebugLineContext {
    @NotNull
    private final DebugLineHeader header;
    @NotNull
    private final DebugLineRegisters registers;
    private final int offsetSize;
    @NotNull
    private final List<String> directories;
    @NotNull
    private final List<DebugLineFileInfo> files;

    public DebugLineContext(@NotNull DebugLineHeader header, @NotNull DebugLineRegisters registers, int offsetSize) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)registers, (String)"registers");
        this.header = header;
        this.registers = registers;
        this.offsetSize = offsetSize;
        Object[] objectArray = new String[]{""};
        this.directories = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new DebugLineFileInfo[]{new DebugLineFileInfo("", "", 0, 0)};
        this.files = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public final DebugLineHeader getHeader() {
        return this.header;
    }

    @NotNull
    public final DebugLineRegisters getRegisters() {
        return this.registers;
    }

    public final int getOffsetSize() {
        return this.offsetSize;
    }

    @NotNull
    public final List<String> getDirectories() {
        return this.directories;
    }

    @NotNull
    public final List<DebugLineFileInfo> getFiles() {
        return this.files;
    }

    public final void defineDirectory(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directories.add(directory);
    }

    public final void defineFile(@NotNull String fileName, int directoryIndex, int modTime, int length) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.files.add(new DebugLineFileInfo(fileName, this.directories.get(directoryIndex), modTime, length));
    }

    @NotNull
    public final DebugLineFileInfo getFileInfo(int fileIndex) {
        return this.files.get(fileIndex);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineContext$DebugLineFileInfo;", "", "name", "", "directory", "modificationTime", "", "length", "(Ljava/lang/String;Ljava/lang/String;II)V", "getDirectory", "()Ljava/lang/String;", "getLength", "()I", "getModificationTime", "getName", "common"})
    public static final class DebugLineFileInfo {
        @NotNull
        private final String name;
        @NotNull
        private final String directory;
        private final int modificationTime;
        private final int length;

        public DebugLineFileInfo(@NotNull String name2, @NotNull String directory, int modificationTime, int length) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.name = name2;
            this.directory = directory;
            this.modificationTime = modificationTime;
            this.length = length;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDirectory() {
            return this.directory;
        }

        public final int getModificationTime() {
            return this.modificationTime;
        }

        public final int getLength() {
            return this.length;
        }
    }
}

