/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.line;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineHeader;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DWARF_32_WORD_SIZE", "", "DWARF_64_WORD_SIZE", "readDebugLineHeader", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineHeader;", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "readDebugLineLength", "Lkotlin/Pair;", "", "common"})
public final class DebugLineHeaderKt {
    private static final int DWARF_32_WORD_SIZE = 4;
    private static final int DWARF_64_WORD_SIZE = 8;

    @NotNull
    public static final DebugLineHeader readDebugLineHeader(@NotNull ByteReader $this$readDebugLineHeader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readDebugLineHeader, (String)"<this>");
        Pair<Integer, Long> pair = DebugLineHeaderKt.readDebugLineLength($this$readDebugLineHeader);
        int wordSize = ((Number)pair.component1()).intValue();
        long length = ((Number)pair.component2()).longValue();
        long endOffset = $this$readDebugLineHeader.getCurrentOffset() + length;
        int version = $this$readDebugLineHeader.readInt(2);
        long headerLength = $this$readDebugLineHeader.readLong(wordSize);
        byte minInstructionLength = $this$readDebugLineHeader.readByte();
        byte maxOperationsPerInstruction = version >= 4 ? $this$readDebugLineHeader.readByte() : (byte)1;
        boolean defaultIsStatement = $this$readDebugLineHeader.readInt(1) != 0;
        byte lineBase = $this$readDebugLineHeader.readByte();
        byte lineRange = $this$readDebugLineHeader.readByte();
        byte by = $this$readDebugLineHeader.readByte();
        byte[] standardOpcodeLengths = new byte[by];
        byte by2 = by;
        for (int i = 1; i < by2; ++i) {
            standardOpcodeLengths[i] = $this$readDebugLineHeader.readByte();
        }
        return new DebugLineHeader(length, version, headerLength, minInstructionLength, maxOperationsPerInstruction, defaultIsStatement, lineBase, lineRange, by, standardOpcodeLengths, endOffset);
    }

    @NotNull
    public static final Pair<Integer, Long> readDebugLineLength(@NotNull ByteReader $this$readDebugLineLength) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readDebugLineLength, (String)"<this>");
        int wordSize = 4;
        long length = $this$readDebugLineLength.readLong(wordSize);
        if (length == -1L) {
            wordSize = 8;
            length = $this$readDebugLineLength.readLong(wordSize);
        }
        return TuplesKt.to((Object)wordSize, (Object)length);
    }
}

