/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.line;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.DwarfException;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineContextKt;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineData;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineEntry;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.opcode.OpcodeProcessorKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"parseCompilationUnit", "", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineEntry;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "context", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineContext;", "parseDebugLinesFromCurrentOffset", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineData;", "offsetSize", "", "add", "", "", "common"})
public final class DebugLineStateMachineKt {
    @NotNull
    public static final DebugLineData parseDebugLinesFromCurrentOffset(@NotNull ByteReader reader, int offsetSize) throws IOException, DwarfException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        DebugLineContext context = DebugLineContextKt.readDebugLineContext(reader, offsetSize);
        return new DebugLineData(DebugLineStateMachineKt.parseCompilationUnit(reader, context), context);
    }

    private static final List<DebugLineEntry> parseCompilationUnit(ByteReader reader, DebugLineContext context) throws IOException, DwarfException {
        List lineEntries = new ArrayList();
        while (reader.getCurrentOffset() < context.getHeader().getEndOffset()) {
            if (OpcodeProcessorKt.processOpcode(reader, context)) {
                DebugLineStateMachineKt.add(lineEntries, context);
            }
            if (!context.getRegisters().isEndSequence()) continue;
            DebugLineStateMachineKt.add(lineEntries, context);
            context.getRegisters().reset();
        }
        return lineEntries;
    }

    private static final void add(List<DebugLineEntry> $this$add, DebugLineContext context) {
        $this$add.add(new DebugLineEntry(context.getRegisters().getAddress(), context.getRegisters().getFile(), context.getRegisters().getLine(), context.getRegisters().getColumn(), context.getRegisters().isEndSequence()));
    }
}

