/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.ndk.elf.ElfNote;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfProgramHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0004\u00a8\u0006\f"}, d2={"parseElfNotes", "", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfNote;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "noteSection", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfProgramHeader;", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeader;", "offset", "", "size", "readElfNote", "common"})
public final class ElfNoteKt {
    @NotNull
    public static final List<ElfNote> parseElfNotes(@NotNull ByteReader reader, @NotNull ElfSectionHeader noteSection) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)noteSection, (String)"noteSection");
        return ElfNoteKt.parseElfNotes(reader, noteSection.getOffset(), noteSection.getSize());
    }

    @NotNull
    public static final List<ElfNote> parseElfNotes(@NotNull ByteReader reader, @NotNull ElfProgramHeader noteSection) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)noteSection, (String)"noteSection");
        return ElfNoteKt.parseElfNotes(reader, noteSection.getOffset(), noteSection.getFileSize());
    }

    @NotNull
    public static final List<ElfNote> parseElfNotes(@NotNull ByteReader reader, long offset, long size) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        List notes = new ArrayList();
        reader.seek(offset);
        long endOffset = offset + size;
        while (reader.getCurrentOffset() != endOffset) {
            notes.add(ElfNoteKt.readElfNote(reader));
        }
        return notes;
    }

    @NotNull
    public static final ElfNote readElfNote(@NotNull ByteReader $this$readElfNote) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readElfNote, (String)"<this>");
        int nameSize = $this$readElfNote.readInt(4);
        int descSize = $this$readElfNote.readInt(4);
        int type = $this$readElfNote.readInt(4);
        String name2 = $this$readElfNote.readNullTerminatedString(Charsets.UTF_8);
        $this$readElfNote.readBytes((4 - nameSize % 4) % 4);
        byte[] desc = $this$readElfNote.readBytes(descSize);
        $this$readElfNote.readBytes((4 - nameSize % 4) % 4);
        return new ElfNote(nameSize, descSize, type, name2, desc);
    }
}

