/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.DwarfException;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.DwarfParserKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.DebugElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfArmVersionKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfException;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileHeaderKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileIdent;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileIdentKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfHandler;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfProgramHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfProgramHeadersKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeadersKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSymbolKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfUuidKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import io.appmetrica.analytics.gradle.common.ndk.io.RandomAccessFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"parseElf", "", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "ident", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileIdent;", "handler", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfHandler;", "input", "Ljava/io/File;", "parseElfSymbols", "elfFileHeader", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileHeader;", "sectionHeaders", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeaders;", "common"})
public final class ElfParserKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseElf(@NotNull File input, @NotNull ElfHandler handler) throws IOException, ElfException, DwarfException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Closeable closeable = new ByteReader(new RandomAccessFileInputStream(input));
        Throwable throwable = null;
        try {
            ByteReader reader = (ByteReader)closeable;
            boolean bl = false;
            ElfParserKt.parseElf(reader, handler);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void parseElf(ByteReader reader, ElfHandler handler) throws IOException, ElfException, DwarfException {
        reader.seek(0L);
        Log.INSTANCE.debug("Reading elf file ident");
        ElfFileIdent elfFileIdent = ElfFileIdentKt.readElfFileIdent(reader);
        Log.INSTANCE.debug("Setting byte order " + elfFileIdent.getElfData().getByteOrder());
        reader.setByteOrder(elfFileIdent.getElfData().getByteOrder());
        ElfParserKt.parseElf(reader, elfFileIdent, handler);
    }

    private static final void parseElf(ByteReader reader, ElfFileIdent ident, ElfHandler handler) throws IOException, ElfException, DwarfException {
        Unit unit;
        Log.INSTANCE.debug("Reading elf file header");
        ElfFileHeader header = ElfFileHeaderKt.readElfFileHeader(reader, ident);
        handler.processElfHeader(header);
        Log.INSTANCE.debug("Reading elf section headers");
        ElfSectionHeaders sectionHeaders = ElfSectionHeadersKt.parseElfSectionHeaders(reader, header);
        handler.processSectionHeaders(sectionHeaders);
        Log.INSTANCE.debug("Reading elf build id");
        ElfProgramHeaders programHeaders = ElfProgramHeadersKt.parseElfProgramHeaders(reader, header);
        byte[] it = ElfUuidKt.parseElfBuildId(reader, sectionHeaders, programHeaders);
        boolean bl = false;
        handler.processElfBuildId(it);
        Log.INSTANCE.debug("Reading arm version");
        String string = ElfArmVersionKt.parseArmVersion(reader, header, sectionHeaders);
        if (string != null) {
            String armVersion = string;
            boolean bl2 = false;
            handler.processArmVersion(armVersion);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            Log.INSTANCE.debug("Arm version not found");
        }
        ElfParserKt.parseElfSymbols(reader, header, sectionHeaders, handler);
    }

    private static final void parseElfSymbols(ByteReader reader, ElfFileHeader elfFileHeader, ElfSectionHeaders sectionHeaders, ElfHandler handler) throws IOException, DwarfException {
        Unit unit;
        handler.startProcessingSymbols();
        Log.INSTANCE.debug("Reading elf symbols");
        handler.processElfSymbols(ElfSymbolKt.parseElfSymbols(reader, elfFileHeader, sectionHeaders));
        Log.INSTANCE.debug("Reading debug elf section headers");
        DebugElfSectionHeaders debugElfSectionHeaders = DebugElfSectionHeaders.Companion.from(sectionHeaders);
        if (debugElfSectionHeaders != null) {
            DebugElfSectionHeaders debugHeaders = debugElfSectionHeaders;
            boolean bl = false;
            DwarfParserKt.parseDwarf(reader, handler, elfFileHeader.getIdent().getElfData().getByteOrder(), debugHeaders);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            Log.INSTANCE.debug("Debug elf section headers not found");
        }
        handler.endProcessingSymbols();
    }
}

