/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.io;

import com.google.gson.GsonBuilder;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfClass;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfData;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfMachine;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSymbol;
import io.appmetrica.analytics.gradle.common.ndk.io.StringUtilsKt;
import io.appmetrica.analytics.gradle.common.ndk.io.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u001a$\u0010\u0002\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u001a\u0015\u0010\n\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u000b*\u0002H\u000b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\r\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"HEX", "", "print", "", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeaders;", "printer", "Lkotlin/Function1;", "", "", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSymbol;", "toPrettyString", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileHeader;", "", "common"})
public final class StringUtilsKt {
    private static final int HEX = 16;

    @NotNull
    public static final String toPrettyString(@NotNull byte[] $this$toPrettyString) {
        Intrinsics.checkNotNullParameter((Object)$this$toPrettyString, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$toPrettyString, (CharSequence)" ", null, null, (int)0, null, (Function1)toPrettyString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String toPrettyString(@NotNull ElfFileHeader $this$toPrettyString) {
        Intrinsics.checkNotNullParameter((Object)$this$toPrettyString, (String)"<this>");
        ElfClass elfClass = $this$toPrettyString.getIdent().getElfClass();
        ElfData elfData = $this$toPrettyString.getIdent().getElfData();
        String string = Integer.toString($this$toPrettyString.getIdent().getElfVersion(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        String string2 = Integer.toString($this$toPrettyString.getIdent().getOsAbi(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        String string3 = Integer.toString($this$toPrettyString.getIdent().getAbiVersion(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        String string4 = Integer.toString($this$toPrettyString.getType(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
        ElfMachine elfMachine = $this$toPrettyString.getMachine();
        String string5 = Long.toString($this$toPrettyString.getVersion(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
        String string6 = Long.toString($this$toPrettyString.getEntry(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(this, checkRadix(radix))");
        String string7 = Long.toString($this$toPrettyString.getProgramHeaderOffset(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(this, checkRadix(radix))");
        String string8 = Long.toString($this$toPrettyString.getSectionHeaderOffset(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(this, checkRadix(radix))");
        String string9 = Long.toString($this$toPrettyString.getFlags(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(this, checkRadix(radix))");
        int n = $this$toPrettyString.getElfHeaderSize();
        int n2 = $this$toPrettyString.getProgramHeaderEntrySize();
        String string10 = Integer.toString($this$toPrettyString.getProgramHeaderNum(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(this, checkRadix(radix))");
        int n3 = $this$toPrettyString.getSectionHeaderEntrySize();
        String string11 = Integer.toString($this$toPrettyString.getSectionHeaderNum(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(this, checkRadix(radix))");
        String string12 = Integer.toString($this$toPrettyString.getSectionHeaderStringIndex(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toString(this, checkRadix(radix))");
        return StringsKt.trimIndent((String)("\n    {\n      \"ident\": {\n        \"elfClass\": \"" + elfClass + "\",\n        \"elfData\": \"" + elfData + "\",\n        \"elfVersion\": " + string + ",\n        \"osAbi\": " + string2 + ",\n        \"abiVersion\": " + string3 + "\n      },\n      \"type\": " + string4 + ",\n      \"machine\": \"" + elfMachine + "\",\n      \"version\": " + string5 + ",\n      \"entry\": " + string6 + ",\n      \"programHeaderOffset\": " + string7 + ",\n      \"sectionHeaderOffset\": " + string8 + ",\n      \"flags\": " + string9 + ",\n      \"elfHeaderSize\": " + n + ",\n      \"programHeaderEntrySize\": " + n2 + ",\n      \"programHeaderNum\": " + string10 + ",\n      \"sectionHeaderEntrySize\": " + n3 + ",\n      \"sectionHeaderNum\": " + string11 + ",\n      \"sectionHeaderStringIndex\": " + string12 + "\n    }\n"));
    }

    @NotNull
    public static final <T> String toPrettyString(T $this$toPrettyString) {
        String string = new GsonBuilder().setPrettyPrinting().serializeNulls().create().toJson($this$toPrettyString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().setPrettyP\u2026s().create().toJson(this)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final void print(@NotNull ElfSectionHeaders $this$print, @NotNull Function1<? super String, Unit> printer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$print, (String)"<this>");
        Intrinsics.checkNotNullParameter(printer, (String)"printer");
        Map<String, ElfSectionHeader> $this$map$iv = $this$print.getHeadersByName();
        boolean $i$f$map = false;
        Map<String, ElfSectionHeader> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ElfSectionHeader header = (ElfSectionHeader)entry.getValue();
            Pair[] pairArray = new Pair[11];
            pairArray[0] = TuplesKt.to((Object)"Name string", (Object)header.getNameString());
            String string = Integer.toString(header.getName(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            pairArray[1] = TuplesKt.to((Object)"Name", (Object)string);
            String string2 = Integer.toString(header.getType(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            pairArray[2] = TuplesKt.to((Object)"Type", (Object)string2);
            String string3 = Long.toString(header.getFlags(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
            pairArray[3] = TuplesKt.to((Object)"Flags", (Object)string3);
            String string4 = Long.toString(header.getAddress(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
            pairArray[4] = TuplesKt.to((Object)"Address", (Object)string4);
            String string5 = Long.toString(header.getOffset(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
            pairArray[5] = TuplesKt.to((Object)"Offset", (Object)string5);
            pairArray[6] = TuplesKt.to((Object)"Size", (Object)header.getSize());
            String string6 = Integer.toString(header.getLink(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(this, checkRadix(radix))");
            pairArray[7] = TuplesKt.to((Object)"Link", (Object)string6);
            String string7 = Integer.toString(header.getInfo(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(this, checkRadix(radix))");
            pairArray[8] = TuplesKt.to((Object)"Info", (Object)string7);
            String string8 = Long.toString(header.getAddressAlign(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(this, checkRadix(radix))");
            pairArray[9] = TuplesKt.to((Object)"Address align", (Object)string8);
            String string9 = Long.toString(header.getEntrySize(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(this, checkRadix(radix))");
            pairArray[10] = TuplesKt.to((Object)"Entry size", (Object)string9);
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        List list = null;
        List list2 = (List)destination$iv$iv;
        new Table(list2, list, n, defaultConstructorMarker).print(printer);
    }

    /*
     * WARNING - void declaration
     */
    public static final void print(@NotNull List<ElfSymbol> $this$print, @NotNull Function1<? super String, Unit> printer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$print, (String)"<this>");
        Intrinsics.checkNotNullParameter(printer, (String)"printer");
        Iterable $this$map$iv = $this$print;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void symbol;
            ElfSymbol elfSymbol = (ElfSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[7];
            pairArray[0] = TuplesKt.to((Object)"Name string", (Object)symbol.getNameString());
            String string = Integer.toString(symbol.getName(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            pairArray[1] = TuplesKt.to((Object)"Name", (Object)string);
            String string2 = Long.toString(symbol.getValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            pairArray[2] = TuplesKt.to((Object)"Value", (Object)string2);
            pairArray[3] = TuplesKt.to((Object)"Size", (Object)symbol.getSize());
            String string3 = Integer.toString(symbol.getInfo(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
            pairArray[4] = TuplesKt.to((Object)"Info", (Object)string3);
            String string4 = Integer.toString(symbol.getOther(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
            pairArray[5] = TuplesKt.to((Object)"Other", (Object)string4);
            String string5 = Integer.toString(symbol.getSectionTableIndex(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
            pairArray[6] = TuplesKt.to((Object)"Index", (Object)string5);
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        List list = null;
        List list2 = (List)destination$iv$iv;
        new Table(list2, list, n, defaultConstructorMarker).print(printer);
    }
}

