/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.tasks;

import com.google.gson.Gson;
import io.appmetrica.analytics.gradle.common.BuildInfo;
import io.appmetrica.analytics.gradle.common.MappingType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Make task cache is in progress")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020 H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000b\u00a8\u0006%"}, d2={"Lio/appmetrica/analytics/gradle/common/tasks/ResourcesGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildInfoFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildInfoFile", "()Lorg/gradle/api/file/RegularFileProperty;", "mappingType", "Lorg/gradle/api/provider/Property;", "Lio/appmetrica/analytics/gradle/common/MappingType;", "getMappingType", "()Lorg/gradle/api/provider/Property;", "ndkEnable", "", "getNdkEnable", "offline", "getOffline", "resDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getResDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "splitVersionCodes", "Lorg/gradle/api/provider/SetProperty;", "", "getSplitVersionCodes", "()Lorg/gradle/api/provider/SetProperty;", "versionCode", "getVersionCode", "versionName", "", "getVersionName", "createBuildIdResFile", "", "buildId", "createInfoFile", "createKeepResFile", "taskAction", "common"})
public abstract class ResourcesGeneratorTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<String> getVersionName();

    @Input
    @NotNull
    public abstract Property<Integer> getVersionCode();

    @Input
    @NotNull
    public abstract Property<MappingType> getMappingType();

    @Input
    @NotNull
    public abstract SetProperty<Integer> getSplitVersionCodes();

    @Input
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Input
    @NotNull
    public abstract Property<Boolean> getNdkEnable();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResDirectory();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBuildInfoFile();

    @TaskAction
    public final void taskAction() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String buildId = string;
        this.createKeepResFile();
        this.createBuildIdResFile(buildId);
        this.createInfoFile(buildId);
    }

    /*
     * WARNING - void declaration
     */
    private final void createKeepResFile() {
        void $this$flatMapTo$iv$iv;
        Object[] objectArray;
        Object object = this.getResDirectory().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resDirectory.asFile.get()");
        Object[] it = objectArray = FilesKt.resolve((File)((File)object), (String)"raw");
        boolean bl = false;
        it.mkdirs();
        Object[] resDir = objectArray;
        it = new String[]{"com.yandex.android.appmetrica", "io.appmetrica.analytics"};
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])it);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String prefix = (String)element$iv$iv;
            boolean bl2 = false;
            Object object2 = new String[]{"@string", "@bool"};
            object2 = CollectionsKt.listOf((Object[])object2);
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void type;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add((String)type + "/" + prefix + "*");
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        String keepList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        FilesKt.writeText$default((File)FilesKt.resolve((File)resDir, (String)"keep_appmetrica_resources.xml"), (String)StringsKt.trimIndent((String)("\n                    <?xml version=\"1.0\" encoding=\"utf-8\"?>\n                    <resources\n                        xmlns:tools=\"http://schemas.android.com/tools\"\n                        tools:keep=\"" + keepList + "\"\n                    />\n                ")), null, (int)2, null);
    }

    private final void createBuildIdResFile(String buildId) {
        File file;
        Object object = this.getResDirectory().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resDirectory.asFile.get()");
        File it = file = FilesKt.resolve((File)((File)object), (String)"values");
        boolean bl = false;
        it.mkdirs();
        File resDir = file;
        FilesKt.writeText$default((File)FilesKt.resolve((File)resDir, (String)"appmetrica_resources.xml"), (String)StringsKt.trimIndent((String)("\n                    <?xml version=\"1.0\" encoding=\"utf-8\"?>\n                    <resources xmlns:tools=\"http://schemas.android.com/tools\">\n                        <string name=\"com.yandex.android.appmetrica.build_id\">" + buildId + "</string>\n                        <string name=\"io.appmetrica.analytics.build_id\">" + buildId + "</string>\n                        <bool name=\"com.yandex.android.appmetrica.is_offline\">" + this.getOffline().get() + "</bool>\n                        <bool name=\"io.appmetrica.analytics.is_offline\">" + this.getOffline().get() + "</bool>\n                        <bool name=\"com.yandex.android.appmetrica.ndk.enable\">" + this.getNdkEnable().get() + "</bool>\n                        <bool name=\"io.appmetrica.analytics.ndk.enable\">" + this.getNdkEnable().get() + "</bool>\n                    </resources>\n                ")), null, (int)2, null);
    }

    private final void createInfoFile(String buildId) {
        Integer n;
        String string = (String)this.getVersionName().getOrNull();
        if (string == null) {
            string = "";
        }
        if ((n = (Integer)this.getVersionCode().getOrNull()) == null) {
            n = 0;
        }
        int n2 = ((Number)n).intValue();
        Object object = this.getMappingType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mappingType.get()");
        MappingType mappingType = (MappingType)((Object)object);
        Object object2 = this.getSplitVersionCodes().getOrElse((Object)SetsKt.emptySet());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"splitVersionCodes.getOrElse(emptySet())");
        BuildInfo buildInfo = new BuildInfo(buildId, string, n2, mappingType, (Set)object2);
        File file = ((RegularFile)this.getBuildInfoFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildInfoFile.get().asFile");
        String string2 = new Gson().toJson((Object)buildInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Gson().toJson(buildInfo)");
        FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
    }
}

