/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.plugin;

import io.appmetrica.analytics.gradle.agp4.Agp4AndroidApplicationHelper;
import io.appmetrica.analytics.gradle.agp7.Agp7AndroidApplicationHelper;
import io.appmetrica.analytics.gradle.agp8.Agp8AndroidApplicationHelper;
import io.appmetrica.analytics.gradle.common.AGPVersion;
import io.appmetrica.analytics.gradle.common.VersionNumber;
import io.appmetrica.analytics.gradle.common.api.AndroidApplicationHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lio/appmetrica/analytics/gradle/plugin/AndroidApplicationHelperCreator;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "agp7Version", "Lio/appmetrica/analytics/gradle/common/VersionNumber;", "agp8Version", "create", "Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationHelper;"})
public final class AndroidApplicationHelperCreator {
    @NotNull
    private final Project project;
    @NotNull
    private final VersionNumber agp7Version;
    @NotNull
    private final VersionNumber agp8Version;

    public AndroidApplicationHelperCreator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.agp7Version = VersionNumber.Companion.parse("7.2.0");
        this.agp8Version = VersionNumber.Companion.parse("8.1.0");
    }

    @NotNull
    public final AndroidApplicationHelper create() {
        VersionNumber agpVersion = AGPVersion.INSTANCE.current(this.project);
        return agpVersion.compareTo(this.agp7Version) < 0 ? (AndroidApplicationHelper)new Agp4AndroidApplicationHelper(this.project) : (agpVersion.compareTo(this.agp8Version) < 0 ? (AndroidApplicationHelper)new Agp7AndroidApplicationHelper(this.project) : (AndroidApplicationHelper)new Agp8AndroidApplicationHelper(this.project));
    }
}

