/*
 * Decompiled with CFR 0.152.
 */
package io.approov.service.okhttp;

import android.content.Context;
import android.util.Log;
import com.criticalblue.approovsdk.Approov;
import io.approov.service.okhttp.ApproovException;
import io.approov.service.okhttp.ApproovNetworkException;
import io.approov.service.okhttp.ApproovRejectionException;
import io.approov.service.okhttp.ApproovTokenInterceptor;
import io.approov.service.okhttp.PrefetchCallbackHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import okhttp3.CertificatePinner;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class ApproovService {
    private static final String TAG = "ApproovService";
    private static final String APPROOV_TOKEN_HEADER = "Approov-Token";
    private static final String APPROOV_TOKEN_PREFIX = "";
    private static final String DEFAULT_BUILDER_NAME = "_default";
    private static boolean isInitialized = false;
    private static boolean proceedOnNetworkFail = false;
    private static Map<String, OkHttpClient.Builder> okHttpBuilders = null;
    private static Map<String, OkHttpClient> okHttpClients = null;
    private static String approovTokenHeader = null;
    private static String approovTokenPrefix = null;
    private static String bindingHeader = null;
    private static Map<String, String> substitutionHeaders = null;
    private static Set<String> substitutionQueryParams = null;
    private static Map<String, Pattern> exclusionURLRegexs = null;

    private ApproovService() {
    }

    public static void initialize(Context context, String config) {
        isInitialized = false;
        proceedOnNetworkFail = false;
        okHttpBuilders = new HashMap<String, OkHttpClient.Builder>();
        okHttpBuilders.put(DEFAULT_BUILDER_NAME, new OkHttpClient.Builder());
        okHttpClients = new HashMap<String, OkHttpClient>();
        approovTokenHeader = APPROOV_TOKEN_HEADER;
        approovTokenPrefix = APPROOV_TOKEN_PREFIX;
        bindingHeader = null;
        substitutionHeaders = new HashMap<String, String>();
        substitutionQueryParams = new HashSet<String>();
        exclusionURLRegexs = new HashMap<String, Pattern>();
        try {
            if (config.length() != 0) {
                Approov.initialize((Context)context, (String)config, (String)"auto", (String)"init-fetch");
            }
            Approov.setUserProperty((String)"approov-service-okhttp");
            isInitialized = true;
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Approov initialization failed: " + e.getMessage()));
        }
    }

    public static void initialize(Context context, String config, String comment) {
        try {
            ApproovService.initialize(context, config);
            if (comment != null && comment.length() != 0) {
                Approov.initialize((Context)context, (String)config, (String)"auto", (String)comment);
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Approov initialization failed: " + e.getMessage()));
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)("Approov initialization failed: " + e.getMessage()));
        }
    }

    public static synchronized void setProceedOnNetworkFail(boolean proceed) {
        Log.d((String)TAG, (String)("setProceedOnNetworkFail " + proceed));
        proceedOnNetworkFail = proceed;
        okHttpClients.clear();
    }

    public static synchronized void setDevKey(String devKey) throws ApproovException {
        try {
            Approov.setDevKey((String)devKey);
            Log.d((String)TAG, (String)"setDevKey");
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static synchronized void setApproovHeader(String header, String prefix) {
        Log.d((String)TAG, (String)("setApproovHeader " + header + ", " + prefix));
        approovTokenHeader = header;
        approovTokenPrefix = prefix;
        okHttpClients.clear();
    }

    public static synchronized void setBindingHeader(String header) {
        Log.d((String)TAG, (String)("setBindingHeader " + header));
        bindingHeader = header;
        okHttpClients.clear();
    }

    public static synchronized void addSubstitutionHeader(String header, String requiredPrefix) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("addSubstitutionHeader " + header + ", " + requiredPrefix));
            if (requiredPrefix == null) {
                substitutionHeaders.put(header, APPROOV_TOKEN_PREFIX);
            } else {
                substitutionHeaders.put(header, requiredPrefix);
            }
            okHttpClients.clear();
        }
    }

    public static synchronized void removeSubstitutionHeader(String header) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("removeSubstitutionHeader " + header));
            substitutionHeaders.remove(header);
            okHttpClients.clear();
        }
    }

    public static synchronized void addSubstitutionQueryParam(String key) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("addSubstitutionQueryParam " + key));
            substitutionQueryParams.add(key);
            okHttpClients.clear();
        }
    }

    public static synchronized void removeSubstitutionQueryParam(String key) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("removeSubstitutionQueryParam " + key));
            substitutionQueryParams.remove(key);
            okHttpClients.clear();
        }
    }

    public static synchronized void addExclusionURLRegex(String urlRegex) {
        if (isInitialized) {
            try {
                Pattern pattern = Pattern.compile(urlRegex);
                exclusionURLRegexs.put(urlRegex, pattern);
                okHttpClients.clear();
                Log.d((String)TAG, (String)("addExclusionURLRegex " + urlRegex));
            }
            catch (PatternSyntaxException e) {
                Log.e((String)TAG, (String)("addExclusionURLRegex " + urlRegex + " error: " + e.getMessage()));
            }
        }
    }

    public static synchronized void removeExclusionURLRegex(String urlRegex) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("removeExclusionURLRegex " + urlRegex));
            exclusionURLRegexs.remove(urlRegex);
            okHttpClients.clear();
        }
    }

    public static synchronized void prefetch() {
        if (isInitialized) {
            Approov.fetchApproovToken((Approov.TokenFetchCallback)new PrefetchCallbackHandler(), (String)"approov.io");
        }
    }

    public static void precheck() throws ApproovException {
        Approov.TokenFetchResult approovResults;
        try {
            approovResults = Approov.fetchSecureStringAndWait((String)"precheck-dummy-key", null);
            Log.d((String)TAG, (String)("precheck: " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
            throw new ApproovRejectionException("precheck: " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("precheck: " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS && approovResults.getStatus() != Approov.TokenFetchStatus.UNKNOWN_KEY) {
            throw new ApproovException("precheck:" + approovResults.getStatus().toString());
        }
    }

    public static String getDeviceID() throws ApproovException {
        try {
            String deviceID = Approov.getDeviceID();
            Log.d((String)TAG, (String)("getDeviceID: " + deviceID));
            return deviceID;
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
    }

    public static void setDataHashInToken(String data) throws ApproovException {
        try {
            Approov.setDataHashInToken((String)data);
            Log.d((String)TAG, (String)"setDataHashInToken");
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static String fetchToken(String url) throws ApproovException {
        Approov.TokenFetchResult approovResults;
        try {
            approovResults = Approov.fetchApproovTokenAndWait((String)url);
            Log.d((String)TAG, (String)("fetchToken: " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("fetchToken: " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS) {
            throw new ApproovException("fetchToken: " + approovResults.getStatus().toString());
        }
        return approovResults.getToken();
    }

    public static String getMessageSignature(String message) throws ApproovException {
        try {
            String signature = Approov.getMessageSignature((String)message);
            Log.d((String)TAG, (String)"getMessageSignature");
            if (signature == null) {
                throw new ApproovException("no signature available");
            }
            return signature;
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static String fetchSecureString(String key, String newDef) throws ApproovException {
        Approov.TokenFetchResult approovResults;
        String type = "lookup";
        if (newDef != null) {
            type = "definition";
        }
        try {
            approovResults = Approov.fetchSecureStringAndWait((String)key, (String)newDef);
            Log.d((String)TAG, (String)("fetchSecureString " + type + ": " + key + ", " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
            throw new ApproovRejectionException("fetchSecureString " + type + " for " + key + ": " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("fetchSecureString " + type + " for " + key + ":" + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS && approovResults.getStatus() != Approov.TokenFetchStatus.UNKNOWN_KEY) {
            throw new ApproovException("fetchSecureString " + type + " for " + key + ":" + approovResults.getStatus().toString());
        }
        return approovResults.getSecureString();
    }

    public static String fetchCustomJWT(String payload) throws ApproovException {
        Approov.TokenFetchResult approovResults;
        try {
            approovResults = Approov.fetchCustomJWTAndWait((String)payload);
            Log.d((String)TAG, (String)("fetchCustomJWT: " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
            throw new ApproovRejectionException("fetchCustomJWT: " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("fetchCustomJWT: " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS) {
            throw new ApproovException("fetchCustomJWT: " + approovResults.getStatus().toString());
        }
        return approovResults.getToken();
    }

    public static synchronized void clearOkHttpClient() {
        Log.d((String)TAG, (String)"OkHttp clients cleared");
        okHttpClients.clear();
    }

    public static synchronized void setOkHttpClientBuilder(String builderName, OkHttpClient.Builder builder) {
        Log.d((String)TAG, (String)("OkHttp client builder set for " + builderName));
        okHttpBuilders.put(builderName, builder);
        okHttpClients.remove(builderName);
    }

    public static synchronized void setOkHttpClientBuilder(OkHttpClient.Builder builder) {
        ApproovService.setOkHttpClientBuilder(DEFAULT_BUILDER_NAME, builder);
    }

    public static synchronized OkHttpClient getOkHttpClient(String builderName) {
        OkHttpClient okHttpClient = okHttpClients.get(builderName);
        if (okHttpClient == null) {
            OkHttpClient.Builder okHttpBuilder = okHttpBuilders.get(builderName);
            if (okHttpBuilder == null) {
                Log.d((String)TAG, (String)("No builder available for " + builderName));
                okHttpBuilder = new OkHttpClient.Builder();
            }
            if (isInitialized) {
                Interceptor interceptor;
                CertificatePinner.Builder pinBuilder = new CertificatePinner.Builder();
                Map allPins = Approov.getPins((String)"public-key-sha256");
                for (Map.Entry entry : allPins.entrySet()) {
                    String domain = (String)entry.getKey();
                    if (domain.equals("*")) continue;
                    List pins = (List)entry.getValue();
                    if (pins.isEmpty() && allPins.get("*") != null) {
                        pins = (List)allPins.get("*");
                    }
                    for (String pin : pins) {
                        pinBuilder = pinBuilder.add(domain, new String[]{"sha256/" + pin});
                    }
                }
                List interceptors = okHttpBuilder.interceptors();
                Iterator iter = interceptors.iterator();
                while (iter.hasNext()) {
                    interceptor = (Interceptor)iter.next();
                    if (!(interceptor instanceof ApproovTokenInterceptor)) continue;
                    iter.remove();
                }
                Log.d((String)TAG, (String)("Building new Approov OkHttpClient for " + builderName));
                interceptor = new ApproovTokenInterceptor(approovTokenHeader, approovTokenPrefix, bindingHeader, proceedOnNetworkFail, substitutionHeaders, substitutionQueryParams, exclusionURLRegexs);
                okHttpClient = okHttpBuilder.certificatePinner(pinBuilder.build()).addInterceptor(interceptor).build();
            } else {
                Log.e((String)TAG, (String)"Cannot build Approov OkHttpClient as not initialized");
                okHttpClient = okHttpBuilder.build();
            }
            okHttpClients.put(builderName, okHttpClient);
        }
        return okHttpClient;
    }

    public static synchronized OkHttpClient getOkHttpClient() {
        return ApproovService.getOkHttpClient(DEFAULT_BUILDER_NAME);
    }
}

