/*
 * Decompiled with CFR 0.152.
 */
package io.approov.service.okhttp;

import android.util.Log;
import com.criticalblue.approovsdk.Approov;
import io.approov.service.okhttp.ApproovException;
import io.approov.service.okhttp.ApproovNetworkException;
import io.approov.service.okhttp.ApproovRejectionException;
import io.approov.service.okhttp.ApproovService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class ApproovTokenInterceptor
implements Interceptor {
    private static final String TAG = "ApproovInterceptor";
    private String approovTokenHeader;
    private String approovTokenPrefix;
    private String bindingHeader;
    private boolean proceedOnNetworkFail;
    private Map<String, String> substitutionHeaders;
    private Map<String, Pattern> substitutionQueryParams;
    private Map<String, Pattern> exclusionURLRegexs;

    public ApproovTokenInterceptor(String approovTokenHeader, String approovTokenPrefix, String bindingHeader, boolean proceedOnNetworkFail, Map<String, String> substitutionHeaders, Set<String> substitutionQueryParams, Map<String, Pattern> exclusionURLRegexs) {
        this.approovTokenHeader = approovTokenHeader;
        this.approovTokenPrefix = approovTokenPrefix;
        this.bindingHeader = bindingHeader;
        this.proceedOnNetworkFail = proceedOnNetworkFail;
        this.substitutionHeaders = new HashMap<String, String>(substitutionHeaders);
        this.substitutionQueryParams = new HashMap<String, Pattern>();
        for (String key : substitutionQueryParams) {
            try {
                Pattern pattern = Pattern.compile("[\\?&]" + key + "=([^&;]+)");
                this.substitutionQueryParams.put(key, pattern);
            }
            catch (PatternSyntaxException e) {
                Log.e((String)TAG, (String)("addSubstitutionQueryParam " + key + " error: " + e.getMessage()));
            }
        }
        this.exclusionURLRegexs = new HashMap<String, Pattern>(exclusionURLRegexs);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String url = request.url().toString();
        for (Pattern pattern : this.exclusionURLRegexs.values()) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find()) continue;
            return chain.proceed(request);
        }
        if (this.bindingHeader != null && request.headers().names().contains(this.bindingHeader)) {
            Approov.setDataHashInToken((String)request.header(this.bindingHeader));
        }
        String host = request.url().host();
        Approov.TokenFetchResult approovResults = Approov.fetchApproovTokenAndWait((String)host);
        Log.d((String)TAG, (String)("Token for " + host + ": " + approovResults.getLoggableToken()));
        if (approovResults.isConfigChanged()) {
            Approov.fetchConfig();
            ApproovService.clearOkHttpClient();
        }
        if (approovResults.isForceApplyPins()) {
            ApproovService.clearOkHttpClient();
            throw new ApproovNetworkException("Pins need to be updated");
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.SUCCESS) {
            request = request.newBuilder().header(this.approovTokenHeader, this.approovTokenPrefix + approovResults.getToken()).build();
        } else if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            if (!this.proceedOnNetworkFail) {
                throw new ApproovNetworkException("Approov token fetch for " + host + ": " + approovResults.getStatus().toString());
            }
        } else if (approovResults.getStatus() != Approov.TokenFetchStatus.NO_APPROOV_SERVICE && approovResults.getStatus() != Approov.TokenFetchStatus.UNKNOWN_URL && approovResults.getStatus() != Approov.TokenFetchStatus.UNPROTECTED_URL) {
            throw new ApproovException("Approov token fetch for " + host + ": " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS && approovResults.getStatus() != Approov.TokenFetchStatus.UNPROTECTED_URL) {
            return chain.proceed(request);
        }
        for (Map.Entry entry : this.substitutionHeaders.entrySet()) {
            String header = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            String value = request.header(header);
            if (value == null || !value.startsWith(prefix) || value.length() <= prefix.length()) continue;
            approovResults = Approov.fetchSecureStringAndWait((String)value.substring(prefix.length()), null);
            Log.d((String)TAG, (String)("Substituting header: " + header + ", " + approovResults.getStatus().toString()));
            if (approovResults.getStatus() == Approov.TokenFetchStatus.SUCCESS) {
                request = request.newBuilder().header(header, prefix + approovResults.getSecureString()).build();
                continue;
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
                throw new ApproovRejectionException("Header substitution for " + header + ": " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
                if (this.proceedOnNetworkFail) continue;
                throw new ApproovNetworkException("Header substitution for " + header + ": " + approovResults.getStatus().toString());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.UNKNOWN_KEY) continue;
            throw new ApproovException("Header substitution for " + header + ": " + approovResults.getStatus().toString());
        }
        String currentURL = request.url().toString();
        for (Map.Entry<String, Pattern> entry : this.substitutionQueryParams.entrySet()) {
            String queryKey = entry.getKey();
            Pattern pattern = entry.getValue();
            Matcher matcher = pattern.matcher(currentURL);
            if (!matcher.find()) continue;
            String queryValue = matcher.group(1);
            approovResults = Approov.fetchSecureStringAndWait((String)queryValue, null);
            Log.d((String)TAG, (String)("Substituting query parameter: " + queryKey + ", " + approovResults.getStatus().toString()));
            if (approovResults.getStatus() == Approov.TokenFetchStatus.SUCCESS) {
                currentURL = new StringBuilder(currentURL).replace(matcher.start(1), matcher.end(1), approovResults.getSecureString()).toString();
                request = request.newBuilder().url(currentURL).build();
                continue;
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
                throw new ApproovRejectionException("Query parameter substitution for " + queryKey + ": " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
                if (this.proceedOnNetworkFail) continue;
                throw new ApproovNetworkException("Query parameter substitution for " + queryKey + ": " + approovResults.getStatus().toString());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.UNKNOWN_KEY) continue;
            throw new ApproovException("Query parameter substitution for " + queryKey + ": " + approovResults.getStatus().toString());
        }
        return chain.proceed(request);
    }
}

