/*
 * Decompiled with CFR 0.152.
 */
package io.approov.service.okhttp;

import android.util.Log;
import com.criticalblue.approovsdk.Approov;
import io.approov.service.okhttp.ApproovException;
import io.approov.service.okhttp.ApproovInterceptorExtensions;
import io.approov.service.okhttp.ApproovNetworkException;
import io.approov.service.okhttp.ApproovRejectionException;
import io.approov.service.okhttp.ApproovRequestMutations;
import io.approov.service.okhttp.ApproovService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class ApproovTokenInterceptor
implements Interceptor {
    private static final String TAG = "ApproovTokenInterceptor";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        ApproovInterceptorExtensions extensions;
        String originalURL;
        ApproovRequestMutations changes = new ApproovRequestMutations();
        Request request = chain.request();
        String url = request.url().toString();
        for (Pattern pattern : ApproovService.getExclusionURLRegexs().values()) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find()) continue;
            return chain.proceed(request);
        }
        String bindingHeader = ApproovService.getBindingHeader();
        if (bindingHeader != null && request.headers().names().contains(bindingHeader)) {
            Approov.setDataHashInToken((String)request.header(bindingHeader));
        }
        String host = request.url().host();
        Approov.TokenFetchResult approovResults = Approov.fetchApproovTokenAndWait((String)host);
        Log.d((String)TAG, (String)("Token for " + host + ": " + approovResults.getLoggableToken()));
        if (approovResults.isConfigChanged()) {
            Approov.fetchConfig();
            ApproovService.rebuildPins();
            Log.d((String)TAG, (String)"Dynamic configuration updated");
        }
        boolean aChange = false;
        String setTokenHeaderKey = null;
        String setTokenHeaderValue = null;
        if (approovResults.getStatus() == Approov.TokenFetchStatus.SUCCESS) {
            aChange = true;
            setTokenHeaderKey = ApproovService.getApproovTokenHeader();
            setTokenHeaderValue = ApproovService.getApproovTokenPrefix() + approovResults.getToken();
        } else if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            if (!ApproovService.getProceedOnNetworkFail()) {
                throw new ApproovNetworkException("Approov token fetch for " + host + ": " + approovResults.getStatus().toString());
            }
        } else if (approovResults.getStatus() != Approov.TokenFetchStatus.NO_APPROOV_SERVICE && approovResults.getStatus() != Approov.TokenFetchStatus.UNKNOWN_URL && approovResults.getStatus() != Approov.TokenFetchStatus.UNPROTECTED_URL) {
            throw new ApproovException("Approov token fetch for " + host + ": " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS && approovResults.getStatus() != Approov.TokenFetchStatus.UNPROTECTED_URL) {
            return chain.proceed(request);
        }
        Map<String, String> substitutionHeaders = ApproovService.getSubstitutionHeaders();
        LinkedHashMap<String, String> setSubstitutionHeaders = new LinkedHashMap<String, String>(substitutionHeaders.size());
        for (Map.Entry<String, String> entry : substitutionHeaders.entrySet()) {
            String header = entry.getKey();
            String prefix = entry.getValue();
            String value = request.header(header);
            if (value == null || !value.startsWith(prefix) || value.length() <= prefix.length()) continue;
            approovResults = Approov.fetchSecureStringAndWait((String)value.substring(prefix.length()), null);
            Log.d((String)TAG, (String)("Substituting header: " + header + ", " + approovResults.getStatus().toString()));
            if (approovResults.getStatus() == Approov.TokenFetchStatus.SUCCESS) {
                aChange = true;
                setSubstitutionHeaders.put(header, prefix + approovResults.getSecureString());
                continue;
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
                throw new ApproovRejectionException("Header substitution for " + header + ": " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
                if (ApproovService.getProceedOnNetworkFail()) continue;
                throw new ApproovNetworkException("Header substitution for " + header + ": " + approovResults.getStatus().toString());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.UNKNOWN_KEY) continue;
            throw new ApproovException("Header substitution for " + header + ": " + approovResults.getStatus().toString());
        }
        String replacementURL = originalURL = request.url().toString();
        Map<String, Pattern> substitutionQueryParams = ApproovService.getSubstitutionQueryParams();
        ArrayList<String> queryKeys = new ArrayList<String>(substitutionQueryParams.size());
        for (Map.Entry entry : substitutionQueryParams.entrySet()) {
            String queryKey = (String)entry.getKey();
            Pattern pattern = (Pattern)entry.getValue();
            Matcher matcher = pattern.matcher(replacementURL);
            if (!matcher.find()) continue;
            String queryValue = matcher.group(1);
            approovResults = Approov.fetchSecureStringAndWait((String)queryValue, null);
            Log.d((String)TAG, (String)("Substituting query parameter: " + queryKey + ", " + approovResults.getStatus().toString()));
            if (approovResults.getStatus() == Approov.TokenFetchStatus.SUCCESS) {
                aChange = true;
                queryKeys.add(queryKey);
                replacementURL = new StringBuilder(replacementURL).replace(matcher.start(1), matcher.end(1), approovResults.getSecureString()).toString();
                continue;
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
                throw new ApproovRejectionException("Query parameter substitution for " + queryKey + ": " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
                if (ApproovService.getProceedOnNetworkFail()) continue;
                throw new ApproovNetworkException("Query parameter substitution for " + queryKey + ": " + approovResults.getStatus().toString());
            }
            if (approovResults.getStatus() == Approov.TokenFetchStatus.UNKNOWN_KEY) continue;
            throw new ApproovException("Query parameter substitution for " + queryKey + ": " + approovResults.getStatus().toString());
        }
        if (aChange) {
            Request.Builder builder = request.newBuilder();
            if (setTokenHeaderKey != null) {
                builder.header(setTokenHeaderKey, setTokenHeaderValue);
                changes.setTokenHeaderKey(setTokenHeaderKey);
            }
            if (!setSubstitutionHeaders.isEmpty()) {
                for (Map.Entry entry : setSubstitutionHeaders.entrySet()) {
                    builder.header((String)entry.getKey(), (String)entry.getValue());
                }
                changes.setSubstitutionHeaderKeys(new ArrayList<String>(setSubstitutionHeaders.keySet()));
            }
            if (!originalURL.equals(replacementURL)) {
                builder.url(replacementURL);
                changes.setSubstitutionQueryParamResults(originalURL, queryKeys);
            }
            request = builder.build();
        }
        if ((extensions = ApproovService.getApproovInterceptorExtensions()) != null) {
            request = extensions.processedRequest(request, changes);
        }
        return chain.proceed(request);
    }
}

