/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.ListElement;
import io.approov.util.http.sfv.Parameterizable;
import io.approov.util.http.sfv.Parameters;
import java.util.List;
import java.util.Objects;

public class InnerList
implements ListElement<List<Item<?>>>,
Parameterizable<List<Item<?>>> {
    private final List<Item<?>> value;
    private final Parameters params;

    private InnerList(List<Item<?>> value, Parameters params) {
        this.value = Objects.requireNonNull(value, "value must not be null");
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static InnerList valueOf(List<Item<?>> value) {
        return new InnerList(value, Parameters.EMPTY);
    }

    public InnerList withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new InnerList(this.value, params);
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        String separator = "";
        sb.append('(');
        for (Item<?> i : this.value) {
            sb.append(separator);
            separator = " ";
            i.serializeTo(sb);
        }
        sb.append(')');
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }

    @Override
    public List<Item<?>> get() {
        return this.value;
    }
}

