/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.Parameters;
import io.approov.util.http.sfv.Utils;
import java.util.Objects;

public class TokenItem
implements Item<String> {
    private final String value;
    private final Parameters params;

    private TokenItem(String value, Parameters params) {
        this.value = TokenItem.checkParam(Objects.requireNonNull(value, "value must not be null"));
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static TokenItem valueOf(String value) {
        return new TokenItem(value, Parameters.EMPTY);
    }

    @Override
    public TokenItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new TokenItem(this.value, params);
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        sb.append(this.value);
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }

    @Override
    public String get() {
        return this.value;
    }

    private static String checkParam(String value) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Token can not be empty");
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ((i != 0 || c == '*' || Utils.isAlpha(c)) && c > ' ' && c < '\u007f' && "\"(),;<=>?@[\\]{}".indexOf(c) < 0) continue;
            throw new IllegalArgumentException(String.format("Invalid character in Token at position %d: '%c' (0x%04x)", i, Character.valueOf(c), (int)c));
        }
        return value;
    }
}

