/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.Parameters;
import java.util.Objects;

public class BooleanItem
implements Item<Boolean> {
    private final boolean value;
    private final Parameters params;
    private static final BooleanItem TRUE = new BooleanItem(true, Parameters.EMPTY);
    private static final BooleanItem FALSE = new BooleanItem(false, Parameters.EMPTY);

    private BooleanItem(boolean value, Parameters params) {
        this.value = value;
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static BooleanItem valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public BooleanItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new BooleanItem(this.value, params);
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        sb.append(this.value ? "?1" : "?0");
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }

    @Override
    public Boolean get() {
        return this.value;
    }
}

