/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.NumberItem;
import io.approov.util.http.sfv.Parameters;
import java.math.BigDecimal;
import java.util.Objects;

public class DecimalItem
implements NumberItem<BigDecimal> {
    private final long value;
    private final Parameters params;
    private static final long MIN = -999999999999999L;
    private static final long MAX = 999999999999999L;
    private static final BigDecimal THOUSAND = new BigDecimal(1000);

    private DecimalItem(long value, Parameters params) {
        if (value < -999999999999999L || value > 999999999999999L) {
            throw new IllegalArgumentException("value must be in the range from -999999999999999 to 999999999999999");
        }
        this.value = value;
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static DecimalItem valueOf(long value) {
        return new DecimalItem(value, Parameters.EMPTY);
    }

    public static DecimalItem valueOf(BigDecimal value) {
        BigDecimal permille = Objects.requireNonNull(value, "value must not be null").multiply(THOUSAND);
        return DecimalItem.valueOf(permille.longValue());
    }

    @Override
    public DecimalItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new DecimalItem(this.value, params);
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        String sign = this.value < 0L ? "-" : "";
        long abs = Math.abs(this.value);
        long left = abs / 1000L;
        long right = abs % 1000L;
        if (right % 10L == 0L) {
            right /= 10L;
        }
        if (right % 10L == 0L) {
            right /= 10L;
        }
        sb.append(sign).append(left).append('.').append(right);
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder(20)).toString();
    }

    @Override
    public BigDecimal get() {
        return BigDecimal.valueOf(this.value, 3);
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public int getDivisor() {
        return 1000;
    }
}

