/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import java.nio.CharBuffer;

public class ParseException
extends IllegalArgumentException {
    private final int position;
    private final String data;
    private static final long serialVersionUID = -5222947525946866985L;

    public ParseException(String message, String input, int position, Throwable cause) {
        super(message, cause);
        this.position = position;
        this.data = input;
    }

    public ParseException(String message, CharBuffer input, int position, Throwable cause) {
        super(message, cause);
        this.position = position;
        this.data = ParseException.asString(input);
    }

    public ParseException(String message, String input, int position) {
        this(message, input, position, null);
    }

    public ParseException(String message, CharBuffer input, Throwable cause) {
        this(message, ParseException.asString(input), input.position(), cause);
    }

    public ParseException(String message, CharBuffer input) {
        this(message, ParseException.asString(input), input.position(), null);
    }

    public String getData() {
        return this.data;
    }

    public int getPosition() {
        return this.position;
    }

    public String getDiagnostics() {
        StringBuilder sb = new StringBuilder();
        sb.append(">>").append(this.data).append("<<").append('\n');
        sb.append("  ");
        for (int i = 0; i < this.position; ++i) {
            sb.append('-');
        }
        sb.append("^ ");
        if (this.position < this.data.length()) {
            char c = this.data.charAt(this.position);
            sb.append(String.format("(0x%02x) ", c));
        }
        sb.append(super.getMessage()).append('\n');
        return sb.toString();
    }

    private static String asString(CharBuffer input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.position() + input.remaining(); ++i) {
            sb.append(input.get(i));
        }
        return sb.toString();
    }
}

