/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import android.util.Base64;
import io.approov.util.http.sfv.BooleanItem;
import io.approov.util.http.sfv.ByteSequenceItem;
import io.approov.util.http.sfv.DateItem;
import io.approov.util.http.sfv.DecimalItem;
import io.approov.util.http.sfv.Dictionary;
import io.approov.util.http.sfv.DisplayStringItem;
import io.approov.util.http.sfv.InnerList;
import io.approov.util.http.sfv.IntegerItem;
import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.ListElement;
import io.approov.util.http.sfv.NumberItem;
import io.approov.util.http.sfv.OuterList;
import io.approov.util.http.sfv.Parameterizable;
import io.approov.util.http.sfv.Parameters;
import io.approov.util.http.sfv.ParseException;
import io.approov.util.http.sfv.StringItem;
import io.approov.util.http.sfv.TokenItem;
import io.approov.util.http.sfv.Utils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class Parser {
    private final CharBuffer input;
    private final List<Integer> startPositions;
    private static final char EOD = '\uffff';

    public Parser(String input) {
        this(Collections.singletonList(Objects.requireNonNull(input, "input must not be null")));
    }

    public Parser(String ... input) {
        this(Arrays.asList(input));
    }

    public Parser(Iterable<String> fieldLines) {
        CharSequence sb = null;
        String str = null;
        List startPositions = Collections.emptyList();
        for (String s : Objects.requireNonNull(fieldLines, "fieldLines must not be null")) {
            Objects.requireNonNull(s, "field line must not be null");
            if (str == null) {
                str = Parser.checkASCII(s);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder();
                ((StringBuilder)sb).append(str);
            }
            if (startPositions.isEmpty()) {
                startPositions = new ArrayList();
            }
            startPositions.add(((StringBuilder)sb).length());
            ((StringBuilder)sb).append(",").append(Parser.checkASCII(s));
        }
        if (str == null) {
            throw new ParseException("Empty input", "", 0);
        }
        this.input = CharBuffer.wrap(sb != null ? sb : str);
        this.startPositions = startPositions;
    }

    private static String checkASCII(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u007f') continue;
            throw new ParseException(String.format("Invalid character in field line at position %d: '%c' (0x%04x) (input: %s)", i, Character.valueOf(c), (int)c, value), value, i);
        }
        return value;
    }

    private DateItem internalParseBareDate() {
        int sign = 1;
        StringBuilder inputNumber = new StringBuilder(21);
        if (!this.checkNextChar("@")) {
            throw this.complaint("Illegal start for Date: '" + this.input + "'");
        }
        this.advance();
        if (this.checkNextChar('-')) {
            sign = -1;
            this.advance();
        }
        if (!this.checkNextChar("0123456789")) {
            throw this.complaint("Illegal start inside a Date: '" + this.input + "'");
        }
        boolean done = false;
        while (this.hasRemaining() && !done) {
            char c = this.peek();
            if (Utils.isDigit(c)) {
                inputNumber.append(c);
                this.advance();
            } else {
                done = true;
            }
            if (inputNumber.length() <= 15) continue;
            this.backout();
            throw this.complaint("Date too long: " + inputNumber.length() + " characters");
        }
        long l = Long.parseLong(inputNumber.toString());
        return DateItem.valueOf((long)sign * l);
    }

    private NumberItem<?> internalParseBareIntegerOrDecimal() {
        boolean isDecimal = false;
        int sign = 1;
        StringBuilder inputNumber = new StringBuilder(20);
        if (this.checkNextChar('-')) {
            sign = -1;
            this.advance();
        }
        if (!this.checkNextChar("0123456789")) {
            throw this.complaint("Illegal start for Integer or Decimal: '" + this.input + "'");
        }
        boolean done = false;
        while (this.hasRemaining() && !done) {
            char c = this.peek();
            if (Utils.isDigit(c)) {
                inputNumber.append(c);
                this.advance();
            } else if (!isDecimal && c == '.') {
                if (inputNumber.length() > 12) {
                    throw this.complaint("Illegal position for decimal point in Decimal after '" + inputNumber + "'");
                }
                inputNumber.append(c);
                isDecimal = true;
                this.advance();
            } else {
                done = true;
            }
            if (inputNumber.length() <= (isDecimal ? 16 : 15)) continue;
            this.backout();
            throw this.complaint((isDecimal ? "Decimal" : "Integer") + " too long: " + inputNumber.length() + " characters");
        }
        if (!isDecimal) {
            long l = Long.parseLong(inputNumber.toString());
            return IntegerItem.valueOf((long)sign * l);
        }
        int dotPos = inputNumber.indexOf(".");
        int fracLen = inputNumber.length() - dotPos - 1;
        if (fracLen < 1) {
            this.backout();
            throw this.complaint("Decimal must not end in '.'");
        }
        if (fracLen == 1) {
            inputNumber.append("00");
        } else if (fracLen == 2) {
            inputNumber.append("0");
        } else if (fracLen > 3) {
            this.backout();
            throw this.complaint("Maximum number of fractional digits is 3, found: " + fracLen + ", in: " + inputNumber);
        }
        inputNumber.deleteCharAt(dotPos);
        long l = Long.parseLong(inputNumber.toString());
        return DecimalItem.valueOf((long)sign * l);
    }

    private DateItem internalParseDate() {
        DateItem result = this.internalParseBareDate();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private NumberItem<?> internalParseIntegerOrDecimal() {
        NumberItem<?> result = this.internalParseBareIntegerOrDecimal();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private StringItem internalParseBareString() {
        if (this.getOrEOD() != '\"') {
            throw this.complaint("String must start with double quote: '" + this.input + "'");
        }
        StringBuilder outputString = new StringBuilder(this.length());
        while (this.hasRemaining()) {
            if (this.startPositions.contains(this.position())) {
                throw this.complaint("String crosses field line boundary at position " + this.position());
            }
            char c = this.get();
            if (c == '\\') {
                c = this.getOrEOD();
                if (c == '\uffff') {
                    throw this.complaint("Incomplete escape sequence at position " + this.position());
                }
                if (c != '\"' && c != '\\') {
                    this.backout();
                    throw this.complaint("Invalid escape sequence character '" + c + "' at position " + this.position());
                }
                outputString.append(c);
                continue;
            }
            if (c == '\"') {
                return StringItem.valueOf(outputString.toString());
            }
            if (c < ' ' || c >= '\u007f') {
                throw this.complaint("Invalid character in String at position " + this.position());
            }
            outputString.append(c);
        }
        throw this.complaint("Closing DQUOTE missing");
    }

    private DisplayStringItem internalParseBareDisplayString() {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
        if (this.getOrEOD() != '%') {
            throw this.complaint("DisplayString must start with a percent sign: '" + this.input + "'");
        }
        if (this.getOrEOD() != '\"') {
            throw this.complaint("DisplayString must continue with a double quote: '" + this.input + "'");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(this.length() * 2);
        int startpos = this.position();
        while (this.hasRemaining()) {
            if (this.startPositions.contains(this.position())) {
                throw this.complaint("Display String crosses field line boundary at position " + this.position());
            }
            char c = this.get();
            if (c == '%') {
                char c1 = this.getOrEOD();
                if (c1 == '\uffff') {
                    throw this.complaint("Incomplete percent escape sequence at position " + this.position());
                }
                if (!Parser.isHex(c1)) {
                    this.backout();
                    throw this.complaint("Invalid percent escape sequence character '" + c + "' at position " + this.position());
                }
                char c2 = this.getOrEOD();
                if (c2 == '\uffff') {
                    throw this.complaint("Incomplete percent escape sequence at position " + this.position());
                }
                if (!Parser.isHex(c2)) {
                    this.backout();
                    throw this.complaint("Invalid percent escape sequence character '" + c + "' at position " + this.position());
                }
                output.write(Parser.decodeHex(c1, c2));
                continue;
            }
            if (c == '\"') {
                ByteBuffer bytes = ByteBuffer.wrap(output.toByteArray());
                int blen = bytes.remaining();
                try {
                    return DisplayStringItem.valueOf(decoder.decode(bytes).toString());
                }
                catch (CharacterCodingException ex) {
                    int length = this.position() - startpos - 1;
                    char[] chars = new char[length];
                    this.input.position(startpos);
                    this.input.get(chars, 0, length);
                    int[] offsets = new int[blen];
                    int j = 0;
                    for (int i = 0; i < blen; ++i) {
                        offsets[i] = j;
                        if (chars[j] == '%') {
                            j += 3;
                            continue;
                        }
                        ++j;
                    }
                    int failpos = startpos + offsets[blen - bytes.remaining()];
                    throw this.complaint("Invalid UTF-8 sequence (" + ex.getMessage() + ") before position " + failpos, failpos, ex);
                }
            }
            if (c < ' ' || c >= '\u007f') {
                throw this.complaint("Invalid character in Display String at position " + this.position());
            }
            output.write(c);
        }
        throw this.complaint("Closing DQUOTE missing");
    }

    private StringItem internalParseString() {
        StringItem result = this.internalParseBareString();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private DisplayStringItem internalParseDisplayString() {
        DisplayStringItem result = this.internalParseBareDisplayString();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private TokenItem internalParseBareToken() {
        char c = this.getOrEOD();
        if (c != '*' && !Utils.isAlpha(c)) {
            throw this.complaint("Token must start with ALPHA or *: '" + this.input + "'");
        }
        StringBuilder outputString = new StringBuilder(this.length());
        outputString.append(c);
        boolean done = false;
        while (this.hasRemaining() && !done) {
            c = this.peek();
            if (c <= ' ' || c >= '\u007f' || "\"(),;<=>?@[\\]{}".indexOf(c) >= 0) {
                done = true;
                continue;
            }
            this.advance();
            outputString.append(c);
        }
        return TokenItem.valueOf(outputString.toString());
    }

    private TokenItem internalParseToken() {
        TokenItem result = this.internalParseBareToken();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private static boolean isBase64Char(char c) {
        return Utils.isAlpha(c) || Utils.isDigit(c) || c == '+' || c == '/' || c == '=';
    }

    private ByteSequenceItem internalParseBareByteSequence() {
        if (this.getOrEOD() != ':') {
            throw this.complaint("Byte Sequence must start with colon: " + this.input);
        }
        StringBuilder outputString = new StringBuilder(this.length());
        boolean done = false;
        while (this.hasRemaining() && !done) {
            char c = this.get();
            if (c == ':') {
                done = true;
                continue;
            }
            if (!Parser.isBase64Char(c)) {
                throw this.complaint("Invalid Byte Sequence Character '" + c + "' at position " + this.position());
            }
            outputString.append(c);
        }
        if (!done) {
            throw this.complaint("Byte Sequence must end with COLON: '" + outputString + "'");
        }
        try {
            return ByteSequenceItem.valueOf(Base64.decode((String)outputString.toString(), (int)2));
        }
        catch (IllegalArgumentException ex) {
            throw this.complaint(ex.getMessage(), ex);
        }
    }

    private ByteSequenceItem internalParseByteSequence() {
        ByteSequenceItem result = this.internalParseBareByteSequence();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private BooleanItem internalParseBareBoolean() {
        char c = this.getOrEOD();
        if (c == '\uffff') {
            throw this.complaint("Missing data in Boolean");
        }
        if (c != '?') {
            this.backout();
            throw this.complaint(String.format("Boolean must start with question mark, got '%c'", Character.valueOf(c)));
        }
        c = this.getOrEOD();
        if (c == '\uffff') {
            throw this.complaint("Missing data in Boolean");
        }
        if (c != '0' && c != '1') {
            this.backout();
            throw this.complaint(String.format("Expected '0' or '1' in Boolean, found '%c'", Character.valueOf(c)));
        }
        return BooleanItem.valueOf(c == '1');
    }

    private BooleanItem internalParseBoolean() {
        BooleanItem result = this.internalParseBareBoolean();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private String internalParseKey() {
        char c = this.getOrEOD();
        if (c == '\uffff') {
            throw this.complaint("Missing data in Key");
        }
        if (c != '*' && !Utils.isLcAlpha(c)) {
            this.backout();
            throw this.complaint("Key must start with LCALPHA or '*': " + Parser.format(c));
        }
        StringBuilder result = new StringBuilder();
        result.append(c);
        boolean done = false;
        while (this.hasRemaining() && !done) {
            c = this.peek();
            if (Utils.isLcAlpha(c) || Utils.isDigit(c) || c == '_' || c == '-' || c == '.' || c == '*') {
                result.append(c);
                this.advance();
                continue;
            }
            done = true;
        }
        return result.toString();
    }

    private Parameters internalParseParameters() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        boolean done = false;
        while (this.hasRemaining() && !done) {
            char c = this.peek();
            if (c != ';') {
                done = true;
                continue;
            }
            this.advance();
            this.removeLeadingSP();
            String name = this.internalParseKey();
            Item<Boolean> value = BooleanItem.valueOf(true);
            if (this.peek() == '=') {
                this.advance();
                value = this.internalParseBareItem();
            }
            result.put(name, value);
        }
        return Parameters.valueOf(result);
    }

    private Item<?> internalParseBareItem() {
        if (!this.hasRemaining()) {
            throw this.complaint("Empty string found when parsing Bare Item");
        }
        char c = this.peek();
        if (Utils.isDigit(c) || c == '-') {
            return this.internalParseBareIntegerOrDecimal();
        }
        if (c == '\"') {
            return this.internalParseBareString();
        }
        if (c == '?') {
            return this.internalParseBareBoolean();
        }
        if (c == '*' || Utils.isAlpha(c)) {
            return this.internalParseBareToken();
        }
        if (c == ':') {
            return this.internalParseBareByteSequence();
        }
        if (c == '@') {
            return this.internalParseBareDate();
        }
        if (c == '%') {
            return this.internalParseBareDisplayString();
        }
        throw this.complaint("Unexpected start character in Bare Item: " + Parser.format(c));
    }

    private Item<?> internalParseItem() {
        Item<?> result = this.internalParseBareItem();
        Parameters params = this.internalParseParameters();
        return result.withParams(params);
    }

    private ListElement<?> internalParseItemOrInnerList() {
        return this.peek() == '(' ? this.internalParseInnerList() : this.internalParseItem();
    }

    private List<ListElement<?>> internalParseOuterList() {
        ArrayList result = new ArrayList();
        while (this.hasRemaining()) {
            result.add(this.internalParseItemOrInnerList());
            this.removeLeadingOWS();
            if (!this.hasRemaining()) {
                return result;
            }
            char c = this.get();
            if (c != ',') {
                this.backout();
                throw this.complaint("Expected COMMA in List, got: " + Parser.format(c));
            }
            this.removeLeadingOWS();
            if (this.hasRemaining()) continue;
            throw this.complaint("Found trailing COMMA in List");
        }
        return result;
    }

    private List<Item<?>> internalParseBareInnerList() {
        char c = this.getOrEOD();
        if (c != '(') {
            throw this.complaint("Inner List must start with '(': " + this.input);
        }
        ArrayList result = new ArrayList();
        boolean done = false;
        while (this.hasRemaining() && !done) {
            this.removeLeadingSP();
            c = this.peek();
            if (c == ')') {
                this.advance();
                done = true;
                continue;
            }
            Item<?> item = this.internalParseItem();
            result.add(item);
            c = this.peek();
            if (c == '\uffff') {
                throw this.complaint("Missing data in Inner List");
            }
            if (c == ' ' || c == ')') continue;
            throw this.complaint("Expected SP or ')' in Inner List, got: " + Parser.format(c));
        }
        if (!done) {
            throw this.complaint("Inner List must end with ')': " + this.input);
        }
        return result;
    }

    private InnerList internalParseInnerList() {
        List<Item<?>> result = this.internalParseBareInnerList();
        Parameters params = this.internalParseParameters();
        return InnerList.valueOf(result).withParams(params);
    }

    private Dictionary internalParseDictionary() {
        LinkedHashMap result = new LinkedHashMap();
        while (this.hasRemaining()) {
            BooleanItem member;
            String name = this.internalParseKey();
            if (this.peek() == '=') {
                this.advance();
                member = this.internalParseItemOrInnerList();
            } else {
                member = BooleanItem.valueOf(true).withParams(this.internalParseParameters());
            }
            result.put(name, member);
            this.removeLeadingOWS();
            if (!this.hasRemaining()) continue;
            char c = this.get();
            if (c != ',') {
                this.backout();
                throw this.complaint("Expected COMMA in Dictionary, found: " + Parser.format(c));
            }
            this.removeLeadingOWS();
            if (this.hasRemaining()) continue;
            throw this.complaint("Found trailing COMMA in Dictionary");
        }
        return Dictionary.valueOf(result);
    }

    protected static DateItem parseDate(String input) {
        Parser p = new Parser(input);
        DateItem result = p.internalParseDate();
        p.assertEmpty("Extra characters in string parsed as Date");
        return result;
    }

    protected static IntegerItem parseInteger(String input) {
        Parser p = new Parser(input);
        NumberItem<?> result = p.internalParseIntegerOrDecimal();
        if (!(result instanceof IntegerItem)) {
            throw p.complaint("String parsed as Integer '" + input + "' is a Decimal");
        }
        p.assertEmpty("Extra characters in string parsed as Integer");
        return (IntegerItem)result;
    }

    protected static DecimalItem parseDecimal(String input) {
        Parser p = new Parser(input);
        NumberItem<?> result = p.internalParseIntegerOrDecimal();
        if (!(result instanceof DecimalItem)) {
            throw p.complaint("String parsed as Decimal '" + input + "' is an Integer");
        }
        p.assertEmpty("Extra characters in string parsed as Decimal");
        return (DecimalItem)result;
    }

    public OuterList parseList() {
        this.removeLeadingSP();
        List<ListElement<?>> result = this.internalParseOuterList();
        this.removeLeadingSP();
        this.assertEmpty("Extra characters in string parsed as List");
        return OuterList.valueOf(result);
    }

    public Dictionary parseDictionary() {
        this.removeLeadingSP();
        Dictionary result = this.internalParseDictionary();
        this.removeLeadingSP();
        this.assertEmpty("Extra characters in string parsed as Dictionary");
        return result;
    }

    public Item<?> parseItem() {
        this.removeLeadingSP();
        Item<?> result = this.internalParseItem();
        this.removeLeadingSP();
        this.assertEmpty("Extra characters in string parsed as Item");
        return result;
    }

    public static OuterList parseList(String input) {
        Parser p = new Parser(input);
        List<ListElement<?>> result = p.internalParseOuterList();
        p.assertEmpty("Extra characters in string parsed as List");
        return OuterList.valueOf(result);
    }

    public static Parameterizable<?> parseItemOrInnerList(String input) {
        Parser p = new Parser(input);
        ListElement<?> result = p.internalParseItemOrInnerList();
        p.assertEmpty("Extra characters in string parsed as Item or Inner List");
        return result;
    }

    public static InnerList parseInnerList(String input) {
        Parser p = new Parser(input);
        InnerList result = p.internalParseInnerList();
        p.assertEmpty("Extra characters in string parsed as Inner List");
        return result;
    }

    public static Dictionary parseDictionary(String input) {
        Parser p = new Parser(input);
        Dictionary result = p.internalParseDictionary();
        p.assertEmpty("Extra characters in string parsed as Dictionary");
        return result;
    }

    public static Item<?> parseItem(String input) {
        Parser p = new Parser(input);
        Item<?> result = p.parseItem();
        p.assertEmpty("Extra characters in string parsed as Item");
        return result;
    }

    public static Item<?> parseBareItem(String input) {
        Parser p = new Parser(input);
        Item<?> result = p.internalParseBareItem();
        p.assertEmpty("Extra characters in string parsed as Bare Item");
        return result;
    }

    public static Parameters parseParameters(String input) {
        Parser p = new Parser(input);
        Parameters result = p.internalParseParameters();
        p.assertEmpty("Extra characters in string parsed as Parameters");
        return result;
    }

    public static String parseKey(String input) {
        Parser p = new Parser(input);
        String result = p.internalParseKey();
        p.assertEmpty("Extra characters in string parsed as Key");
        return result;
    }

    public static NumberItem<?> parseIntegerOrDecimal(String input) {
        Parser p = new Parser(input);
        NumberItem<?> result = p.internalParseIntegerOrDecimal();
        p.assertEmpty("Extra characters in string parsed as Integer or Decimal");
        return result;
    }

    public static StringItem parseString(String input) {
        Parser p = new Parser(input);
        StringItem result = p.internalParseString();
        p.assertEmpty("Extra characters in string parsed as String");
        return result;
    }

    public static DisplayStringItem parseDisplayString(String input) {
        Parser p = new Parser(input);
        DisplayStringItem result = p.internalParseDisplayString();
        p.assertEmpty("Extra characters in string parsed as String");
        return result;
    }

    public static TokenItem parseToken(String input) {
        Parser p = new Parser(input);
        TokenItem result = p.internalParseToken();
        p.assertEmpty("Extra characters in string parsed as Token");
        return result;
    }

    public static ByteSequenceItem parseByteSequence(String input) {
        Parser p = new Parser(input);
        ByteSequenceItem result = p.internalParseByteSequence();
        p.assertEmpty("Extra characters in string parsed as Byte Sequence");
        return result;
    }

    public static BooleanItem parseBoolean(String input) {
        Parser p = new Parser(input);
        BooleanItem result = p.internalParseBoolean();
        p.assertEmpty("Extra characters at position %d in string parsed as Boolean: '%s'");
        return result;
    }

    private void assertEmpty(String message) {
        if (this.hasRemaining()) {
            throw this.complaint(String.format(message, this.position(), this.input));
        }
    }

    private void advance() {
        this.input.position(1 + this.input.position());
    }

    private void backout() {
        this.input.position(-1 + this.input.position());
    }

    private boolean checkNextChar(char c) {
        return this.hasRemaining() && this.input.charAt(0) == c;
    }

    private boolean checkNextChar(String valid) {
        return this.hasRemaining() && valid.indexOf(this.input.charAt(0)) >= 0;
    }

    private char get() {
        return this.input.get();
    }

    private char getOrEOD() {
        return this.hasRemaining() ? (char)this.get() : (char)'\uffff';
    }

    private boolean hasRemaining() {
        return this.input.hasRemaining();
    }

    private int length() {
        return this.input.length();
    }

    private char peek() {
        return this.hasRemaining() ? this.input.charAt(0) : (char)'\uffff';
    }

    private int position() {
        return this.input.position();
    }

    private void removeLeadingSP() {
        while (this.checkNextChar(' ')) {
            this.advance();
        }
    }

    private void removeLeadingOWS() {
        while (this.checkNextChar(" \t")) {
            this.advance();
        }
    }

    private ParseException complaint(String message) {
        return new ParseException(message, this.input);
    }

    private ParseException complaint(String message, Throwable cause) {
        return new ParseException(message, this.input, cause);
    }

    private ParseException complaint(String message, int position, Throwable cause) {
        return new ParseException(message, this.input, position, cause);
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f';
    }

    private static int decodeHex(char c1, char c2) {
        String lookup = "0123456789abcdef";
        return lookup.indexOf(c1) << 4 | lookup.indexOf(c2);
    }

    private static String format(char c) {
        String s = c == '\t' ? "HTAB" : "'" + c + "'";
        return String.format("%s (\\u%04x)", s, (int)c);
    }
}

