/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.Parameters;
import java.util.Objects;

public class StringItem
implements Item<String> {
    private final String value;
    private final Parameters params;

    private StringItem(String value, Parameters params) {
        this.value = StringItem.checkParam(Objects.requireNonNull(value, "value must not be null"));
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static StringItem valueOf(String value) {
        return new StringItem(value, Parameters.EMPTY);
    }

    @Override
    public StringItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new StringItem(this.value, params);
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        sb.append('\"');
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\"');
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder(2 + this.value.length())).toString();
    }

    @Override
    public String get() {
        return this.value;
    }

    private static String checkParam(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException(String.format("Invalid character in String at position %d: '%c' (0x%04x)", i, Character.valueOf(c), (int)c));
        }
        return value;
    }
}

