/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.sig;

import io.approov.util.http.sfv.Dictionary;
import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.ListElement;
import io.approov.util.http.sfv.OuterList;
import io.approov.util.http.sfv.ParseException;
import io.approov.util.http.sfv.Parser;
import io.approov.util.http.sfv.StringItem;
import java.util.List;
import java.util.regex.Pattern;

public interface ComponentProvider {
    public static final Pattern PATTERN_WHITESPACE = Pattern.compile("[\\s\\t]*\\r\\n[\\s\\t]*");
    public static final String DC_AUTHORITY = "@authority";
    public static final String DC_METHOD = "@method";
    public static final String DC_PATH = "@path";
    public static final String DC_QUERY = "@query";
    public static final String DC_QUERY_PARAM = "@query-param";
    public static final String DC_REQUEST_TARGET = "@request-target";
    public static final String DC_SCHEME = "@scheme";
    public static final String DC_STATUS = "@status";
    public static final String DC_TARGET_URI = "@target-uri";

    public String getMethod();

    public String getAuthority();

    public String getScheme();

    public String getTargetUri();

    public String getRequestTarget();

    public String getPath();

    public String getQuery();

    public String getQueryParam(String var1);

    public boolean hasBody();

    public String getStatus();

    public boolean hasField(String var1);

    public String getField(String var1);

    public static String combineFieldValues(List<String> fields) {
        if (fields == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            String trimmedField = field.trim();
            String replacedField = PATTERN_WHITESPACE.matcher(trimmedField).replaceAll(" ");
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(replacedField);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    default public String getComponentValue(StringItem componentIdentifier) {
        String baseIdentifier = componentIdentifier.get();
        if (baseIdentifier.startsWith("@")) {
            switch (baseIdentifier) {
                case "@method": {
                    return this.getMethod();
                }
                case "@authority": {
                    return this.getAuthority();
                }
                case "@scheme": {
                    return this.getScheme();
                }
                case "@target-uri": {
                    return this.getTargetUri();
                }
                case "@request-target": {
                    return this.getRequestTarget();
                }
                case "@path": {
                    return this.getPath();
                }
                case "@query": {
                    return this.getQuery();
                }
                case "@status": {
                    return this.getStatus();
                }
                case "@query-param": {
                    if (componentIdentifier.getParams().containsKey("name")) {
                        Object nameParameter = componentIdentifier.getParams().get("name");
                        if (nameParameter instanceof StringItem) {
                            String name = ((StringItem)nameParameter).get();
                            return this.getQueryParam(name);
                        }
                        throw new IllegalArgumentException("Invalid Syntax: Value for 'name' parameter of " + baseIdentifier + " must be a StringItem");
                    }
                    throw new IllegalArgumentException("'name' parameter of " + baseIdentifier + " is required");
                }
            }
            throw new IllegalArgumentException("Unknown derived component: " + baseIdentifier);
        }
        if (componentIdentifier.getParams().containsKey("key")) {
            Object keyParameter = componentIdentifier.getParams().get("key");
            if (keyParameter instanceof StringItem) {
                try {
                    String fieldValue = this.getField(baseIdentifier);
                    Dictionary dictionary = Parser.parseDictionary(fieldValue);
                    String key = ((StringItem)keyParameter).get();
                    if (dictionary.get().containsKey(key)) {
                        ListElement dictionaryValue = (ListElement)dictionary.get().get(key);
                        return dictionaryValue.serialize();
                    }
                    throw new IllegalArgumentException("Value for '" + key + "' key of dictionary " + baseIdentifier + " does not exist");
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Field " + baseIdentifier + " is not a dictionary field");
                }
            }
            throw new IllegalArgumentException("Invalid Syntax: Value for 'key' parameter of field " + baseIdentifier + " must be a StringItem");
        }
        if (componentIdentifier.getParams().containsKey("sf")) {
            switch (baseIdentifier) {
                case "accept": 
                case "accept-encoding": 
                case "accept-language": 
                case "accept-patch": 
                case "accept-ranges": 
                case "access-control-allow-headers": 
                case "access-control-allow-methods": 
                case "access-control-expose-headers": 
                case "access-control-request-headers": 
                case "allow": 
                case "alpn": 
                case "connection": 
                case "content-encoding": 
                case "content-language": 
                case "content-length": 
                case "te": 
                case "timing-allow-origin": 
                case "trailer": 
                case "transfer-encoding": 
                case "vary": 
                case "x-xss-protection": 
                case "cache-status": 
                case "proxy-status": 
                case "variant-key": 
                case "x-list": 
                case "x-list-a": 
                case "x-list-b": 
                case "accept-ch": 
                case "example-list": {
                    try {
                        String fieldValue = this.getField(baseIdentifier);
                        OuterList sf = Parser.parseList(fieldValue);
                        return sf.serialize();
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Field " + baseIdentifier + " is not a structured field");
                    }
                }
                case "alt-svc": 
                case "cache-control": 
                case "expect-ct": 
                case "keep-alive": 
                case "pragma": 
                case "prefer": 
                case "preference-applied": 
                case "surrogate-control": 
                case "variants": 
                case "signature": 
                case "signature-input": 
                case "priority": 
                case "x-dictionary": 
                case "example-dict": 
                case "cdn-cache-control": {
                    try {
                        String fieldValue = this.getField(baseIdentifier);
                        Dictionary sf = Parser.parseDictionary(fieldValue);
                        return sf.serialize();
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Field " + baseIdentifier + " is not a structured field");
                    }
                }
                case "access-control-max-age": 
                case "access-control-allow-credentials": 
                case "access-control-allow-origin": 
                case "access-control-request-method": 
                case "age": 
                case "alt-used": 
                case "content-type": 
                case "cross-origin-resource-policy": 
                case "expect": 
                case "host": 
                case "origin": 
                case "retry-after": 
                case "x-content-type-options": 
                case "x-frame-options": 
                case "example-integer": 
                case "example-decimal": 
                case "example-string": 
                case "example-token": 
                case "example-bytesequence": 
                case "example-boolean": {
                    try {
                        String fieldValue = this.getField(baseIdentifier);
                        Item<?> sf = Parser.parseItem(fieldValue);
                        return sf.serialize();
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Field " + baseIdentifier + " is not a structured field");
                    }
                }
            }
            throw new IllegalArgumentException("Field " + baseIdentifier + " is not a structured field");
        }
        return this.getField(baseIdentifier);
    }
}

