/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.sig;

import io.approov.util.http.sfv.StringItem;
import io.approov.util.sig.ComponentProvider;
import io.approov.util.sig.SignatureParameters;

public class SignatureBaseBuilder {
    private final SignatureParameters sigParams;
    private final ComponentProvider ctx;

    public SignatureBaseBuilder(SignatureParameters sigParams, ComponentProvider ctx) {
        this.sigParams = sigParams;
        this.ctx = ctx;
    }

    public String createSignatureBase() {
        StringBuilder base = new StringBuilder();
        for (StringItem componentIdentifier : this.sigParams.getComponentIdentifiers()) {
            String componentValue = this.ctx.getComponentValue(componentIdentifier);
            if (componentValue != null) {
                componentIdentifier.serializeTo(base).append(": ").append(componentValue).append('\n');
                continue;
            }
            throw new RuntimeException("Couldn't find a value for required parameter: " + componentIdentifier.serialize());
        }
        this.sigParams.toComponentIdentifier().serializeTo(base).append(": ");
        this.sigParams.toComponentValue().serializeTo(base);
        return base.toString();
    }
}

