/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.sig;

import androidx.annotation.NonNull;
import io.approov.util.http.sfv.Dictionary;
import io.approov.util.http.sfv.InnerList;
import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.ListElement;
import io.approov.util.http.sfv.NumberItem;
import io.approov.util.http.sfv.Parameters;
import io.approov.util.http.sfv.StringItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SignatureParameters
implements Cloneable {
    private static final String ALG = "alg";
    private static final String CREATED = "created";
    private static final String EXPIRES = "expires";
    private static final String KEYID = "keyid";
    private static final String NONCE = "nonce";
    private static final String TAG = "tag";
    private boolean debugMode;
    private List<StringItem> componentIdentifiers;
    private Map<String, Object> parameters;

    public SignatureParameters() {
        this.componentIdentifiers = new ArrayList<StringItem>();
        this.parameters = new LinkedHashMap<String, Object>();
    }

    public SignatureParameters(SignatureParameters base) {
        this.componentIdentifiers = new ArrayList<StringItem>(base.componentIdentifiers);
        this.parameters = new LinkedHashMap<String, Object>(base.parameters);
    }

    List<StringItem> getComponentIdentifiers() {
        return this.componentIdentifiers;
    }

    Map<String, Object> getParameters() {
        return this.parameters;
    }

    public SignatureParameters setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getAlg() {
        return (String)this.getParameters().get(ALG);
    }

    public SignatureParameters setAlg(String alg) {
        this.getParameters().put(ALG, alg);
        return this;
    }

    public Long getCreated() {
        return (Long)this.getParameters().get(CREATED);
    }

    public SignatureParameters setCreated(Long created) {
        this.getParameters().put(CREATED, created);
        return this;
    }

    public Long getExpires() {
        return (Long)this.getParameters().get(EXPIRES);
    }

    public SignatureParameters setExpires(Long expires) {
        this.getParameters().put(EXPIRES, expires);
        return this;
    }

    public String getKeyid() {
        return (String)this.getParameters().get(KEYID);
    }

    public SignatureParameters setKeyid(String keyid) {
        this.getParameters().put(KEYID, keyid);
        return this;
    }

    public String getNonce() {
        return (String)this.getParameters().get(NONCE);
    }

    public SignatureParameters setNonce(String nonce) {
        this.getParameters().put(NONCE, nonce);
        return this;
    }

    public String getTag() {
        return (String)this.getParameters().get(TAG);
    }

    public SignatureParameters setTag(String tag) {
        this.getParameters().put(TAG, tag);
        return this;
    }

    public Object getCustomParameter(String key) {
        return this.getParameters().get(key);
    }

    public Object setCustomParameter(String key, Object value) {
        switch (key) {
            case "alg": {
                String val = (String)value;
                this.setAlg(val);
                break;
            }
            case "created": {
                Long val = (Long)value;
                this.setCreated(val);
                break;
            }
            case "expires": {
                Long val = (Long)value;
                this.setExpires(val);
                break;
            }
            case "keyid": {
                String val = (String)value;
                this.setKeyid(val);
                break;
            }
            case "nonce": {
                String val = (String)value;
                this.setNonce(val);
                break;
            }
            case "tag": {
                String val = (String)value;
                this.setTag(val);
                break;
            }
            default: {
                if (!Item.isItemType(value)) {
                    throw new IllegalArgumentException("Parameter value of unsupported type: " + value.getClass());
                }
                this.getParameters().put(key, value);
            }
        }
        return this;
    }

    public StringItem toComponentIdentifier() {
        return StringItem.valueOf("@signature-params");
    }

    public InnerList toComponentValue() {
        ArrayList identifiers = new ArrayList(this.componentIdentifiers.size());
        identifiers.addAll(this.componentIdentifiers);
        InnerList list = InnerList.valueOf(identifiers);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(this.getParameters());
        list = list.withParams(Parameters.valueOf(params));
        return list;
    }

    public SignatureParameters addComponentIdentifier(String identifier) {
        if (!identifier.startsWith("@")) {
            this.componentIdentifiers.add(StringItem.valueOf(identifier.toLowerCase()));
        } else {
            this.componentIdentifiers.add(StringItem.valueOf(identifier));
        }
        return this;
    }

    public SignatureParameters addComponentIdentifier(StringItem identifier) {
        this.componentIdentifiers.add(identifier);
        return this;
    }

    public boolean containsComponentIdentifier(String identifier) {
        for (StringItem item : this.componentIdentifiers) {
            if (!item.get().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean containsComponentIdentifier(StringItem identifier) {
        String value = identifier.get();
        Parameters params = identifier.getParams();
        for (StringItem item : this.componentIdentifiers) {
            if (!value.equals(identifier.get()) || !params.equals(identifier.getParams())) continue;
            return true;
        }
        return false;
    }

    public static SignatureParameters fromDictionaryEntry(Dictionary signatureInput, String sigId) {
        if (signatureInput.get().containsKey(sigId)) {
            ListElement item = (ListElement)signatureInput.get().get(sigId);
            if (item instanceof InnerList) {
                InnerList coveredComponents = (InnerList)item;
                SignatureParameters params = new SignatureParameters();
                Iterator<Object> iterator = coveredComponents.get().iterator();
                while (iterator.hasNext()) {
                    Item item2 = (Item)iterator.next();
                    params.addComponentIdentifier((StringItem)item2);
                }
                block17: for (Map.Entry entry : coveredComponents.getParams().entrySet()) {
                    Object value;
                    String key;
                    switch (key = (String)entry.getKey()) {
                        case "alg": {
                            value = ((StringItem)entry.getValue()).get();
                            params.setAlg((String)value);
                            continue block17;
                        }
                        case "created": {
                            value = ((NumberItem)entry.getValue()).getAsLong();
                            params.setCreated((Long)value);
                            continue block17;
                        }
                        case "expires": {
                            value = ((NumberItem)entry.getValue()).getAsLong();
                            params.setExpires((Long)value);
                            continue block17;
                        }
                        case "keyid": {
                            value = ((StringItem)entry.getValue()).get();
                            params.setKeyid((String)value);
                            continue block17;
                        }
                        case "nonce": {
                            value = ((StringItem)entry.getValue()).get();
                            params.setNonce((String)value);
                            continue block17;
                        }
                        case "tag": {
                            value = ((StringItem)entry.getValue()).get();
                            params.setTag((String)value);
                            continue block17;
                        }
                    }
                    value = ((Item)entry.getValue()).get();
                    params.getParameters().put(key, value);
                }
                return params;
            }
            throw new IllegalArgumentException("Invalid syntax, identifier '" + sigId + "' must be an inner list");
        }
        throw new IllegalArgumentException("Could not find identifier '" + sigId + "' in dictionary " + signatureInput.serialize());
    }

    @NonNull
    public String toString() {
        return "SignatureParameters: " + this.toComponentValue().serialize();
    }
}

