/*
 * Decompiled with CFR 0.152.
 */
package io.approov.service.okhttp;

import android.content.Context;
import android.util.Log;
import com.criticalblue.approovsdk.Approov;
import io.approov.service.okhttp.ApproovException;
import io.approov.service.okhttp.ApproovInterceptorExtensions;
import io.approov.service.okhttp.ApproovNetworkException;
import io.approov.service.okhttp.ApproovPinningInterceptor;
import io.approov.service.okhttp.ApproovRejectionException;
import io.approov.service.okhttp.ApproovTokenInterceptor;
import io.approov.service.okhttp.PrefetchCallbackHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class ApproovService {
    private static final String TAG = "ApproovService";
    private static final String APPROOV_TOKEN_HEADER = "Approov-Token";
    private static final String APPROOV_TOKEN_PREFIX = "";
    private static final String DEFAULT_BUILDER_NAME = "_default";
    private static boolean isInitialized = false;
    private static String configString;
    private static boolean proceedOnNetworkFail;
    private static ApproovPinningInterceptor pinningInterceptor;
    private static Map<String, OkHttpClient.Builder> okHttpBuilders;
    private static Map<String, OkHttpClient> okHttpClients;
    private static String approovTokenHeader;
    private static String approovTokenPrefix;
    private static String bindingHeader;
    private static ApproovInterceptorExtensions interceptorExtensions;
    private static Map<String, String> substitutionHeaders;
    private static Map<String, Pattern> substitutionQueryParams;
    private static Map<String, Pattern> exclusionURLRegexs;

    private ApproovService() {
    }

    public static synchronized void initialize(Context context, String config, String comment) {
        if (isInitialized && !comment.startsWith("reinit")) {
            if (!config.equals(configString)) {
                throw new IllegalStateException("ApproovService layer is already initialized.");
            }
            Log.d((String)TAG, (String)"Ignoring multiple ApproovService layer initializations with the same config");
        } else {
            isInitialized = false;
            proceedOnNetworkFail = false;
            okHttpBuilders = new HashMap<String, OkHttpClient.Builder>();
            okHttpBuilders.put(DEFAULT_BUILDER_NAME, new OkHttpClient.Builder());
            okHttpClients = new HashMap<String, OkHttpClient>();
            approovTokenHeader = APPROOV_TOKEN_HEADER;
            approovTokenPrefix = APPROOV_TOKEN_PREFIX;
            bindingHeader = null;
            substitutionHeaders = new HashMap<String, String>();
            substitutionQueryParams = new HashMap<String, Pattern>();
            exclusionURLRegexs = new HashMap<String, Pattern>();
            try {
                if (!config.isEmpty()) {
                    Approov.initialize((Context)context.getApplicationContext(), (String)config, (String)"auto", (String)comment);
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("Approov initialization failed: " + e.getMessage()));
                throw e;
            }
            catch (IllegalStateException e) {
                Log.e((String)TAG, (String)("Approov already intialized: Ignoring native layer exception " + e.getMessage()));
            }
            pinningInterceptor = new ApproovPinningInterceptor();
            isInitialized = true;
            configString = config;
            Approov.setUserProperty((String)"approov-service-okhttp");
        }
    }

    public static void initialize(Context context, String config) {
        ApproovService.initialize(context, config, APPROOV_TOKEN_PREFIX);
    }

    public static synchronized void setProceedOnNetworkFail(boolean proceed) {
        Log.d((String)TAG, (String)("setProceedOnNetworkFail " + proceed));
        proceedOnNetworkFail = proceed;
    }

    public static synchronized boolean getProceedOnNetworkFail() {
        return proceedOnNetworkFail;
    }

    public static synchronized void setDevKey(String devKey) throws ApproovException {
        try {
            Approov.setDevKey((String)devKey);
            Log.d((String)TAG, (String)"setDevKey");
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static synchronized void setApproovHeader(String header, String prefix) {
        Log.d((String)TAG, (String)("setApproovHeader " + header + ", " + prefix));
        approovTokenHeader = header;
        approovTokenPrefix = prefix;
    }

    public static synchronized String getApproovTokenHeader() {
        return approovTokenHeader;
    }

    public static synchronized String getApproovTokenPrefix() {
        return approovTokenPrefix;
    }

    public static synchronized void setBindingHeader(String header) {
        Log.d((String)TAG, (String)("setBindingHeader " + header));
        bindingHeader = header;
    }

    static synchronized String getBindingHeader() {
        return bindingHeader;
    }

    public static synchronized void setApproovInterceptorExtensions(ApproovInterceptorExtensions callbacks) {
        if (callbacks == null) {
            Log.d((String)TAG, (String)"Interceptor extension disabled");
        } else {
            Log.d((String)TAG, (String)"Interceptor extension enabled");
        }
        interceptorExtensions = callbacks;
    }

    public static synchronized ApproovInterceptorExtensions getApproovInterceptorExtensions() {
        return interceptorExtensions;
    }

    public static synchronized void addSubstitutionHeader(String header, String requiredPrefix) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("addSubstitutionHeader " + header + ", " + requiredPrefix));
            if (requiredPrefix == null) {
                substitutionHeaders.put(header, APPROOV_TOKEN_PREFIX);
            } else {
                substitutionHeaders.put(header, requiredPrefix);
            }
        }
    }

    public static synchronized void removeSubstitutionHeader(String header) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("removeSubstitutionHeader " + header));
            substitutionHeaders.remove(header);
        }
    }

    public static synchronized Map<String, String> getSubstitutionHeaders() {
        return new HashMap<String, String>(substitutionHeaders);
    }

    public static synchronized void addSubstitutionQueryParam(String key) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("addSubstitutionQueryParam " + key));
            try {
                Pattern pattern = Pattern.compile("[\\?&]" + key + "=([^&;]+)");
                substitutionQueryParams.put(key, pattern);
            }
            catch (PatternSyntaxException e) {
                Log.e((String)TAG, (String)("addSubstitutionQueryParam " + key + " error: " + e.getMessage()));
            }
        }
    }

    public static synchronized void removeSubstitutionQueryParam(String key) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("removeSubstitutionQueryParam " + key));
            substitutionQueryParams.remove(key);
        }
    }

    public static synchronized Map<String, Pattern> getSubstitutionQueryParams() {
        return new HashMap<String, Pattern>(substitutionQueryParams);
    }

    public static synchronized void addExclusionURLRegex(String urlRegex) {
        if (isInitialized) {
            try {
                Pattern pattern = Pattern.compile(urlRegex);
                exclusionURLRegexs.put(urlRegex, pattern);
                Log.d((String)TAG, (String)("addExclusionURLRegex " + urlRegex));
            }
            catch (PatternSyntaxException e) {
                Log.e((String)TAG, (String)("addExclusionURLRegex " + urlRegex + " error: " + e.getMessage()));
            }
        }
    }

    public static synchronized void removeExclusionURLRegex(String urlRegex) {
        if (isInitialized) {
            Log.d((String)TAG, (String)("removeExclusionURLRegex " + urlRegex));
            exclusionURLRegexs.remove(urlRegex);
        }
    }

    static synchronized Map<String, Pattern> getExclusionURLRegexs() {
        return new HashMap<String, Pattern>(exclusionURLRegexs);
    }

    public static synchronized void prefetch() {
        if (isInitialized) {
            Approov.fetchApproovToken((Approov.TokenFetchCallback)new PrefetchCallbackHandler(), (String)"approov.io");
        }
    }

    public static void precheck() throws ApproovException {
        Approov.TokenFetchResult approovResults;
        try {
            approovResults = Approov.fetchSecureStringAndWait((String)"precheck-dummy-key", null);
            Log.d((String)TAG, (String)("precheck: " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
            throw new ApproovRejectionException("precheck: " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("precheck: " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS && approovResults.getStatus() != Approov.TokenFetchStatus.UNKNOWN_KEY) {
            throw new ApproovException("precheck:" + approovResults.getStatus().toString());
        }
    }

    public static String getDeviceID() throws ApproovException {
        try {
            String deviceID = Approov.getDeviceID();
            Log.d((String)TAG, (String)("getDeviceID: " + deviceID));
            return deviceID;
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
    }

    public static void setDataHashInToken(String data) throws ApproovException {
        try {
            Approov.setDataHashInToken((String)data);
            Log.d((String)TAG, (String)"setDataHashInToken");
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static String fetchToken(String url) throws ApproovException {
        Approov.TokenFetchResult approovResults;
        try {
            approovResults = Approov.fetchApproovTokenAndWait((String)url);
            Log.d((String)TAG, (String)("fetchToken: " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("fetchToken: " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS) {
            throw new ApproovException("fetchToken: " + approovResults.getStatus().toString());
        }
        return approovResults.getToken();
    }

    @Deprecated
    public static String getMessageSignature(String message) throws ApproovException {
        return ApproovService.getAccountMessageSignature(message);
    }

    public static String getAccountMessageSignature(String message) throws ApproovException {
        try {
            String signature = Approov.getAccountMessageSignature((String)message);
            Log.d((String)TAG, (String)"getAccountMessageSignature");
            if (signature == null) {
                throw new ApproovException("no account signature available");
            }
            return signature;
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static String getInstallMessageSignature(String message) throws ApproovException {
        try {
            String signature = Approov.getInstallMessageSignature((String)message);
            Log.d((String)TAG, (String)"getInstallMessageSignature");
            if (signature == null) {
                throw new ApproovException("no device signature available");
            }
            return signature;
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
    }

    public static String fetchSecureString(String key, String newDef) throws ApproovException {
        Approov.TokenFetchResult approovResults;
        String type = "lookup";
        if (newDef != null) {
            type = "definition";
        }
        try {
            approovResults = Approov.fetchSecureStringAndWait((String)key, (String)newDef);
            Log.d((String)TAG, (String)("fetchSecureString " + type + ": " + key + ", " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
            throw new ApproovRejectionException("fetchSecureString " + type + " for " + key + ": " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("fetchSecureString " + type + " for " + key + ":" + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS && approovResults.getStatus() != Approov.TokenFetchStatus.UNKNOWN_KEY) {
            throw new ApproovException("fetchSecureString " + type + " for " + key + ":" + approovResults.getStatus().toString());
        }
        return approovResults.getSecureString();
    }

    public static String fetchCustomJWT(String payload) throws ApproovException {
        Approov.TokenFetchResult approovResults;
        try {
            approovResults = Approov.fetchCustomJWTAndWait((String)payload);
            Log.d((String)TAG, (String)("fetchCustomJWT: " + approovResults.getStatus().toString()));
        }
        catch (IllegalStateException e) {
            throw new ApproovException("IllegalState: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ApproovException("IllegalArgument: " + e.getMessage());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.REJECTED) {
            throw new ApproovRejectionException("fetchCustomJWT: " + approovResults.getStatus().toString() + ": " + approovResults.getARC() + " " + approovResults.getRejectionReasons(), approovResults.getARC(), approovResults.getRejectionReasons());
        }
        if (approovResults.getStatus() == Approov.TokenFetchStatus.NO_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.POOR_NETWORK || approovResults.getStatus() == Approov.TokenFetchStatus.MITM_DETECTED) {
            throw new ApproovNetworkException("fetchCustomJWT: " + approovResults.getStatus().toString());
        }
        if (approovResults.getStatus() != Approov.TokenFetchStatus.SUCCESS) {
            throw new ApproovException("fetchCustomJWT: " + approovResults.getStatus().toString());
        }
        return approovResults.getToken();
    }

    static synchronized void rebuildPins() {
        if (pinningInterceptor != null) {
            pinningInterceptor.buildPins();
        }
    }

    public static synchronized void setOkHttpClientBuilder(String builderName, OkHttpClient.Builder builder) {
        Log.d((String)TAG, (String)("OkHttp client builder set for " + builderName));
        OkHttpClient.Builder oldBuilder = okHttpBuilders.put(builderName, builder);
        if (oldBuilder != builder) {
            okHttpClients.remove(builderName);
        }
    }

    public static synchronized void setOkHttpClientBuilder(OkHttpClient.Builder builder) {
        ApproovService.setOkHttpClientBuilder(DEFAULT_BUILDER_NAME, builder);
    }

    public static synchronized OkHttpClient getOkHttpClient(String builderName) {
        OkHttpClient okHttpClient = okHttpClients.get(builderName);
        if (okHttpClient == null) {
            OkHttpClient.Builder okHttpBuilder = okHttpBuilders.get(builderName);
            if (okHttpBuilder == null) {
                Log.d((String)TAG, (String)("No builder available for " + builderName));
                okHttpBuilder = new OkHttpClient.Builder();
            }
            if (isInitialized) {
                Interceptor interceptor;
                List interceptors = okHttpBuilder.interceptors();
                Iterator iter = interceptors.iterator();
                while (iter.hasNext()) {
                    interceptor = (Interceptor)iter.next();
                    if (!(interceptor instanceof ApproovTokenInterceptor)) continue;
                    iter.remove();
                }
                interceptors = okHttpBuilder.networkInterceptors();
                iter = interceptors.iterator();
                while (iter.hasNext()) {
                    interceptor = (Interceptor)iter.next();
                    if (!(interceptor instanceof ApproovPinningInterceptor)) continue;
                    iter.remove();
                }
                Log.d((String)TAG, (String)("Building new Approov OkHttpClient for " + builderName));
                ApproovTokenInterceptor tokenInterceptor = new ApproovTokenInterceptor();
                okHttpClient = okHttpBuilder.addInterceptor((Interceptor)tokenInterceptor).addNetworkInterceptor((Interceptor)pinningInterceptor).build();
            } else {
                Log.e((String)TAG, (String)"Cannot build Approov OkHttpClient as not initialized");
                okHttpClient = okHttpBuilder.build();
            }
            okHttpClients.put(builderName, okHttpClient);
        }
        return okHttpClient;
    }

    public static synchronized OkHttpClient getOkHttpClient() {
        return ApproovService.getOkHttpClient(DEFAULT_BUILDER_NAME);
    }

    static {
        proceedOnNetworkFail = false;
        pinningInterceptor = null;
        okHttpBuilders = null;
        okHttpClients = null;
        approovTokenHeader = null;
        approovTokenPrefix = null;
        bindingHeader = null;
        interceptorExtensions = null;
        substitutionHeaders = null;
        substitutionQueryParams = null;
        exclusionURLRegexs = null;
    }
}

