/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.Parameters;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class DisplayStringItem
implements Item<String> {
    private final String value;
    private final Parameters params;

    private DisplayStringItem(String value, Parameters params) {
        this.value = Objects.requireNonNull(value, "value must not be null");
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static DisplayStringItem valueOf(String value) {
        return new DisplayStringItem(value, Parameters.EMPTY);
    }

    @Override
    public DisplayStringItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new DisplayStringItem(this.value, params);
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        byte[] octets;
        sb.append("%\"");
        for (byte b : octets = this.value.getBytes(StandardCharsets.UTF_8)) {
            if (b == 37 || b == 34 || b <= 31 || b == 127) {
                sb.append('%');
                sb.append(Character.forDigit(b >> 4 & 0xF, 16));
                sb.append(Character.forDigit(b & 0xF, 16));
                continue;
            }
            sb.append((char)b);
        }
        sb.append('\"');
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder(2 + this.value.length())).toString();
    }

    @Override
    public String get() {
        return this.value;
    }
}

