/*
 * Decompiled with CFR 0.152.
 */
package io.approov.service.retrofit;

import android.util.Base64;
import android.util.Log;
import io.approov.service.retrofit.ApproovException;
import io.approov.service.retrofit.ApproovInterceptorExtensions;
import io.approov.service.retrofit.ApproovRequestMutations;
import io.approov.service.retrofit.ApproovService;
import io.approov.util.http.sfv.ByteSequenceItem;
import io.approov.util.http.sfv.Dictionary;
import io.approov.util.sig.ComponentProvider;
import io.approov.util.sig.SignatureBaseBuilder;
import io.approov.util.sig.SignatureParameters;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;

public class ApproovDefaultMessageSigning
implements ApproovInterceptorExtensions {
    private static final String TAG = "ApproovMsgSign";
    public static final String DIGEST_SHA256 = "sha-256";
    public static final String DIGEST_SHA512 = "sha-512";
    public static final String ALG_ES256 = "ecdsa-p256-sha256";
    public static final String ALG_HS256 = "hmac-sha256";
    protected SignatureParametersFactory defaultFactory;
    protected final Map<String, SignatureParametersFactory> hostFactories = new HashMap<String, SignatureParametersFactory>();

    public ApproovDefaultMessageSigning setDefaultFactory(SignatureParametersFactory factory) {
        this.defaultFactory = factory;
        return this;
    }

    public ApproovDefaultMessageSigning putHostFactory(String hostName, SignatureParametersFactory factory) {
        this.hostFactories.put(hostName, factory);
        return this;
    }

    protected SignatureParameters buildSignatureParameters(OkHttpComponentProvider provider, ApproovRequestMutations changes) {
        SignatureParametersFactory factory = this.hostFactories.get(provider.getAuthority());
        if (factory == null && (factory = this.defaultFactory) == null) {
            return null;
        }
        return factory.buildSignatureParameters(provider, changes);
    }

    private static byte[] to32ByteArray(ASN1Integer bytesAsASN1Integer) {
        byte[] bytes32;
        BigInteger bytesAsBigInteger = bytesAsASN1Integer.getValue();
        byte[] bytes = bytesAsBigInteger.toByteArray();
        if (bytes.length < 32) {
            bytes32 = new byte[32];
            System.arraycopy(bytes, 0, bytes32, 32 - bytes.length, bytes.length);
        } else if (bytes.length == 32) {
            bytes32 = bytes;
        } else if (bytes.length == 33 && bytes[0] == 0) {
            bytes32 = new byte[32];
            System.arraycopy(bytes, 1, bytes32, 0, 32);
        } else {
            throw new IllegalArgumentException("Not an ASN.1 DER ES256 signature part");
        }
        return bytes32;
    }

    @Override
    public Request processedRequest(Request request, ApproovRequestMutations changes) throws ApproovException {
        byte[] signature;
        String sigId;
        if (changes == null || changes.getTokenHeaderKey() == null) {
            return request;
        }
        OkHttpComponentProvider provider = new OkHttpComponentProvider(request);
        SignatureParameters params = this.buildSignatureParameters(provider, changes);
        if (params == null) {
            return request;
        }
        SignatureBaseBuilder baseBuilder = new SignatureBaseBuilder(params, provider);
        String message = baseBuilder.createSignatureBase();
        switch (params.getAlg()) {
            case "ecdsa-p256-sha256": {
                sigId = "install";
                String base64 = ApproovService.getInstallMessageSignature(message);
                signature = Base64.decode((String)base64, (int)2);
                try (ASN1InputStream asn1InputStream = new ASN1InputStream(signature);){
                    ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
                    if (sequence instanceof ASN1Sequence) {
                        byte[] rBytes = ApproovDefaultMessageSigning.to32ByteArray((ASN1Integer)sequence.getObjectAt(0));
                        byte[] sBytes = ApproovDefaultMessageSigning.to32ByteArray((ASN1Integer)sequence.getObjectAt(1));
                        signature = new byte[rBytes.length + sBytes.length];
                        System.arraycopy(rBytes, 0, signature, 0, rBytes.length);
                        System.arraycopy(sBytes, 0, signature, rBytes.length, sBytes.length);
                        break;
                    }
                    throw new IllegalStateException("Not an ASN1Sequence");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to decode ASN.1 DER ES256 signature", e);
                }
            }
            case "hmac-sha256": {
                sigId = "account";
                String base64 = ApproovService.getAccountMessageSignature(message);
                signature = Base64.decode((String)base64, (int)2);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported algorithm identifier: " + params.getAlg());
            }
        }
        String sigHeader = Dictionary.valueOf(Map.of(sigId, ByteSequenceItem.valueOf(signature))).serialize();
        String sigInputHeader = Dictionary.valueOf(Map.of(sigId, params.toComponentValue())).serialize();
        Request.Builder signedBuilder = provider.getRequest().newBuilder().addHeader("Signature", sigHeader).addHeader("Signature-Input", sigInputHeader);
        if (params.isDebugMode()) {
            try {
                MessageDigest digestBuilder = MessageDigest.getInstance("SHA-256");
                digestBuilder.reset();
                byte[] digest = digestBuilder.digest(message.getBytes(StandardCharsets.UTF_8));
                String digestHeader = Dictionary.valueOf(Map.of(DIGEST_SHA256, ByteSequenceItem.valueOf(digest))).serialize();
                signedBuilder.addHeader("Signature-Base-Digest", digestHeader);
            }
            catch (NoSuchAlgorithmException e) {
                Log.d((String)TAG, (String)("Failed to get digest algorithm - no debug entry " + e));
            }
        }
        Request signed = signedBuilder.build();
        return signed;
    }

    public static SignatureParametersFactory generateDefaultSignatureParametersFactory() {
        return ApproovDefaultMessageSigning.generateDefaultSignatureParametersFactory(null);
    }

    public static SignatureParametersFactory generateDefaultSignatureParametersFactory(SignatureParameters baseParametersOverride) {
        long defaultExpiresLifetime = 15L;
        SignatureParameters baseParameters = baseParametersOverride != null ? baseParametersOverride : new SignatureParameters().addComponentIdentifier("@method").addComponentIdentifier("@target-uri");
        return new SignatureParametersFactory().setBaseParameters(baseParameters).setUseInstallMessageSigning().setAddCreated(true).setExpiresLifetime(defaultExpiresLifetime).setAddApproovTokenHeader(true).addOptionalHeaders("Authorization", "Content-Length", "Content-Type").setBodyDigestConfig(DIGEST_SHA256, false);
    }

    public static class SignatureParametersFactory {
        protected SignatureParameters baseParameters;
        protected String bodyDigestAlgorithm;
        protected boolean bodyDigestRequired;
        protected boolean useAccountMessageSigning;
        protected boolean addCreated;
        protected long expiresLifetime;
        protected boolean addApproovTokenHeader;
        protected List<String> optionalHeaders;

        public SignatureParametersFactory setBaseParameters(SignatureParameters baseParameters) {
            this.baseParameters = baseParameters;
            return this;
        }

        public SignatureParametersFactory setBodyDigestConfig(String bodyDigestAlgorithm, boolean required) {
            if (bodyDigestAlgorithm == null) {
                required = false;
            } else if (!bodyDigestAlgorithm.equals(ApproovDefaultMessageSigning.DIGEST_SHA256) && !bodyDigestAlgorithm.equals(ApproovDefaultMessageSigning.DIGEST_SHA512)) {
                throw new IllegalArgumentException("Unsupported body digest algorithm: " + bodyDigestAlgorithm);
            }
            this.bodyDigestAlgorithm = bodyDigestAlgorithm;
            this.bodyDigestRequired = required;
            return this;
        }

        public SignatureParametersFactory setUseInstallMessageSigning() {
            this.useAccountMessageSigning = false;
            return this;
        }

        public SignatureParametersFactory setUseAccountMessageSigning() {
            this.useAccountMessageSigning = true;
            return this;
        }

        public SignatureParametersFactory setAddCreated(boolean addCreated) {
            this.addCreated = addCreated;
            return this;
        }

        public SignatureParametersFactory setExpiresLifetime(long expiresLifetime) {
            this.expiresLifetime = expiresLifetime;
            return this;
        }

        public SignatureParametersFactory setAddApproovTokenHeader(boolean addApproovTokenHeader) {
            this.addApproovTokenHeader = addApproovTokenHeader;
            return this;
        }

        public SignatureParametersFactory addOptionalHeaders(String ... headers) {
            if (this.optionalHeaders == null) {
                this.optionalHeaders = new ArrayList<String>(Arrays.asList(headers));
            } else {
                this.optionalHeaders.addAll(Arrays.asList(headers));
            }
            return this;
        }

        protected boolean generateBodyDigest(OkHttpComponentProvider provider, SignatureParameters requestParameters) {
            ByteString digest;
            RequestBody body = provider.request.body();
            if (body == null || body.isOneShot()) {
                return false;
            }
            try {
                if (body.contentLength() <= 0L) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
            Buffer buffer = new Buffer();
            try {
                body.writeTo((BufferedSink)buffer);
            }
            catch (IOException e) {
                return false;
            }
            switch (this.bodyDigestAlgorithm) {
                case "sha-256": {
                    digest = buffer.sha256();
                    break;
                }
                case "sha-512": {
                    digest = buffer.sha512();
                    break;
                }
                default: {
                    return false;
                }
            }
            Dictionary digestHeader = Dictionary.valueOf(Map.of(this.bodyDigestAlgorithm, ByteSequenceItem.valueOf(digest.toByteArray())));
            Request request = provider.getRequest();
            request = request.newBuilder().addHeader("Content-Digest", digestHeader.serialize()).build();
            provider.setRequest(request);
            requestParameters.addComponentIdentifier("Content-Digest");
            return true;
        }

        protected SignatureParameters buildSignatureParameters(OkHttpComponentProvider provider, ApproovRequestMutations changes) {
            SignatureParameters requestParameters = new SignatureParameters(this.baseParameters);
            if (this.useAccountMessageSigning) {
                requestParameters.setAlg(ApproovDefaultMessageSigning.ALG_HS256);
            } else {
                requestParameters.setAlg(ApproovDefaultMessageSigning.ALG_ES256);
            }
            if (this.addCreated || this.expiresLifetime > 0L) {
                long currentTime = System.currentTimeMillis() / 1000L;
                if (this.addCreated) {
                    requestParameters.setCreated(currentTime);
                }
                if (this.expiresLifetime > 0L) {
                    requestParameters.setExpires(currentTime + this.expiresLifetime);
                }
            }
            if (this.addApproovTokenHeader) {
                requestParameters.addComponentIdentifier(changes.getTokenHeaderKey());
            }
            for (String headerName : this.optionalHeaders) {
                if (!provider.hasField(headerName)) continue;
                requestParameters.addComponentIdentifier(headerName);
            }
            if (this.bodyDigestAlgorithm != null && !this.generateBodyDigest(provider, requestParameters) && this.bodyDigestRequired) {
                throw new IllegalStateException("Failed to create required body digest");
            }
            return requestParameters;
        }
    }

    protected static final class OkHttpComponentProvider
    implements ComponentProvider {
        private Request request;
        private HttpUrl okURL;
        private URI jURI;

        OkHttpComponentProvider(Request request) {
            this.request = request;
            this.okURL = request.url();
            this.jURI = this.okURL.uri();
        }

        public Request getRequest() {
            return this.request;
        }

        public void setRequest(Request request) {
            this.request = request;
            this.okURL = request.url();
            this.jURI = this.okURL.uri();
        }

        @Override
        public String getMethod() {
            return this.request.method();
        }

        @Override
        public String getAuthority() {
            return this.okURL.host();
        }

        @Override
        public String getScheme() {
            return this.okURL.scheme();
        }

        @Override
        public String getTargetUri() {
            return this.jURI.toString();
        }

        @Override
        public String getRequestTarget() {
            String reqt = "";
            if (this.jURI.getRawPath() != null) {
                reqt = reqt + this.okURL.encodedPath();
            }
            if (this.jURI.getRawQuery() != null) {
                reqt = reqt + "?" + this.okURL.encodedQuery();
            }
            return reqt;
        }

        @Override
        public String getPath() {
            return this.okURL.encodedPath();
        }

        @Override
        public String getQuery() {
            return this.okURL.encodedQuery();
        }

        @Override
        public String getQueryParam(String name) {
            List values = this.okURL.queryParameterValues(name);
            if (values.isEmpty()) {
                throw new IllegalArgumentException("Could not find query parameter named " + name);
            }
            if (values.size() > 1) {
                return null;
            }
            return (String)values.get(0);
        }

        @Override
        public String getStatus() {
            throw new IllegalStateException("Only requests are supported");
        }

        @Override
        public boolean hasField(String name) {
            List headers = this.request.headers(name);
            return !headers.isEmpty();
        }

        @Override
        public String getField(String name) {
            List headers = this.request.headers(name);
            return ComponentProvider.combineFieldValues(headers);
        }

        @Override
        public boolean hasBody() {
            return this.request.body() != null;
        }
    }
}

