/*
 * Decompiled with CFR 0.152.
 */
package io.approov.service.retrofit;

import android.util.Log;
import com.criticalblue.approovsdk.Approov;
import io.approov.service.retrofit.ApproovNetworkException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.Handshake;
import okhttp3.Interceptor;
import okhttp3.Response;

class ApproovPinningInterceptor
implements Interceptor {
    private static final String TAG = "ApproovPinningInterceptor";
    private static final int maxCachedHandshakes = 10;
    private CertificatePinner certificatePinner;
    private Set<Handshake> knownValidHandshakes = new HashSet<Handshake>();

    public ApproovPinningInterceptor() {
        this.buildPins();
    }

    public synchronized void buildPins() {
        CertificatePinner.Builder pinBuilder = new CertificatePinner.Builder();
        Map allPins = Approov.getPins((String)"public-key-sha256");
        for (Map.Entry entry : allPins.entrySet()) {
            String domain = (String)entry.getKey();
            if (domain.equals("*")) continue;
            List pins = (List)entry.getValue();
            if (pins.isEmpty() && allPins.get("*") != null) {
                pins = (List)allPins.get("*");
            }
            for (String pin : pins) {
                pinBuilder = pinBuilder.add(domain, new String[]{"sha256/" + pin});
            }
        }
        this.certificatePinner = pinBuilder.build();
        this.knownValidHandshakes.clear();
    }

    private synchronized CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    private synchronized boolean isValidHandshake(Handshake handshake) {
        return this.knownValidHandshakes.contains(handshake);
    }

    private synchronized void addValidHandshake(Handshake handshake) {
        if (this.knownValidHandshakes.size() >= 10) {
            this.knownValidHandshakes.clear();
        }
        this.knownValidHandshakes.add(handshake);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Handshake handshake;
        String host = chain.request().url().host();
        Connection connection = chain.connection();
        Handshake handshake2 = handshake = connection != null ? connection.handshake() : null;
        if (handshake == null) {
            throw new ApproovNetworkException("network interceptor has no connection information");
        }
        if (!this.isValidHandshake(handshake)) {
            List certs = handshake.peerCertificates();
            try {
                this.getCertificatePinner().check(host, certs);
            }
            catch (SSLPeerUnverifiedException e) {
                Log.d((String)TAG, (String)("Pinning failure: " + e.toString()));
                connection.socket().close();
                throw e;
            }
            this.addValidHandshake(handshake);
            Log.d((String)TAG, (String)("Valid pinning for: " + handshake.toString()));
        }
        return chain.proceed(chain.request());
    }
}

