/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import android.util.Base64;
import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.Parameters;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteSequenceItem
implements Item<ByteBuffer> {
    private final byte[] value;
    private final Parameters params;

    private ByteSequenceItem(byte[] value, Parameters params) {
        this.value = Objects.requireNonNull(value, "value must not be null");
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static ByteSequenceItem valueOf(byte[] value) {
        return new ByteSequenceItem(value, Parameters.EMPTY);
    }

    @Override
    public ByteSequenceItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new ByteSequenceItem(this.value, params);
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        sb.append(':');
        sb.append(Base64.encodeToString((byte[])this.value, (int)2));
        sb.append(':');
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }

    @Override
    public ByteBuffer get() {
        return ByteBuffer.wrap((byte[])this.value.clone());
    }
}

