/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.ListElement;
import io.approov.util.http.sfv.Type;
import io.approov.util.http.sfv.Utils;
import java.util.Collections;
import java.util.Map;

public class Dictionary
implements Type<Map<String, ListElement<?>>> {
    private final Map<String, ListElement<?>> value;

    private Dictionary(Map<String, ListElement<?>> value) {
        this.value = Collections.unmodifiableMap(Utils.checkKeys(value));
    }

    public static Dictionary valueOf(Map<String, ListElement<?>> value) {
        return new Dictionary(value);
    }

    @Override
    public Map<String, ListElement<?>> get() {
        return this.value;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        String separator = "";
        for (Map.Entry<String, ListElement<?>> e : this.value.entrySet()) {
            sb.append(separator);
            separator = ", ";
            String name = e.getKey();
            ListElement<?> value = e.getValue();
            sb.append(name);
            if (Boolean.TRUE.equals(value.get())) {
                value.getParams().serializeTo(sb);
                continue;
            }
            sb.append("=");
            value.serializeTo(sb);
        }
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }
}

