/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.Item;
import io.approov.util.http.sfv.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Parameters
implements Map<String, Item<?>> {
    private final Map<String, Item<?>> delegate;
    public static final Parameters EMPTY = new Parameters(Collections.emptyMap());

    private Parameters(Map<String, Object> value) {
        this.delegate = Collections.unmodifiableMap(Parameters.checkAndTransformMap(value));
    }

    public static Parameters valueOf(Map<String, Object> value) {
        return new Parameters(value);
    }

    public StringBuilder serializeTo(StringBuilder sb) {
        for (Map.Entry<String, Item<?>> e : this.delegate.entrySet()) {
            sb.append(';').append(e.getKey());
            if (e.getValue().get().equals(Boolean.TRUE)) continue;
            sb.append('=');
            e.getValue().serializeTo(sb);
        }
        return sb;
    }

    private static Map<String, Item<?>> checkAndTransformMap(Map<String, Object> map) {
        LinkedHashMap result = new LinkedHashMap(Objects.requireNonNull(map, "Map must not be null").size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = Utils.checkKey(entry.getKey());
            Item<?> value = Parameters.asItem(key, entry.getValue());
            if (!value.getParams().isEmpty()) {
                throw new IllegalArgumentException("Parameter value for '" + key + "' must be bare item (no parameters)");
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private static Item<?> asItem(String key, Object o) {
        Item<?> item = Item.asItem(o);
        if (item == null) {
            throw new IllegalArgumentException("Can't map value for parameter '" + key + "': " + o.getClass());
        }
        return item;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> compute(String key, BiFunction<? super String, ? super Item<?>, ? extends Item<?>> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> computeIfAbsent(String key, Function<? super String, ? extends Item<?>> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> computeIfPresent(String key, BiFunction<? super String, ? super Item<?>, ? extends Item<?>> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Item<?>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return Objects.equals(this.delegate, o);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Item<?>> action) {
        this.delegate.forEach(action);
    }

    @Override
    public Item<?> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Item<?> getOrDefault(Object key, Item<?> defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Item<?> merge(String key, Item<?> value, BiFunction<? super Item<?>, ? super Item<?>, ? extends Item<?>> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> put(String key, Item<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Item<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> putIfAbsent(String key, Item<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, Item<?> oldValue, Item<?> newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item<?> replace(String key, Item<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Item<?>, ? extends Item<?>> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<Item<?>> values() {
        return this.delegate.values();
    }

    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }
}

