/*
 * Decompiled with CFR 0.152.
 */
package io.approov.util.http.sfv;

import io.approov.util.http.sfv.NumberItem;
import io.approov.util.http.sfv.Parameters;
import java.util.Objects;

public class DateItem
implements NumberItem<Long> {
    private final long value;
    private final Parameters params;
    private static final long MIN = -999999999999999L;
    private static final long MAX = 999999999999999L;

    private DateItem(long value, Parameters params) {
        if (value < -999999999999999L || value > 999999999999999L) {
            throw new IllegalArgumentException("value must be in the range from -999999999999999 to 999999999999999");
        }
        this.value = value;
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static DateItem valueOf(long value) {
        return new DateItem(value, Parameters.EMPTY);
    }

    @Override
    public DateItem withParams(Parameters params) {
        if (Objects.requireNonNull(params, "params must not be null").isEmpty()) {
            return this;
        }
        return new DateItem(this.value, params);
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public StringBuilder serializeTo(StringBuilder sb) {
        sb.append('@');
        sb.append(this.value);
        this.params.serializeTo(sb);
        return sb;
    }

    @Override
    public String serialize() {
        return this.serializeTo(new StringBuilder()).toString();
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public int getDivisor() {
        return 1;
    }
}

