/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.converter.JacksonRequestConverter;
import io.apptik.comm.jus.converter.JacksonResponseConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        this.mapper = mapper;
    }

    public Converter<NetworkResponse, ?> fromResponse(Type type, Annotation[] annotations) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.reader(javaType);
        return new JacksonResponseConverter(reader);
    }

    public Converter<?, NetworkRequest> toRequest(Type type, Annotation[] annotations) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerWithType(javaType);
        return new JacksonRequestConverter(writer);
    }
}

