/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.converter;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.http.MediaType;
import java.io.IOException;

public final class JacksonRequestBodyConverter<T>
implements Converter<T, NetworkRequest> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private final ObjectWriter adapter;

    public JacksonRequestBodyConverter(ObjectWriter adapter) {
        this.adapter = adapter;
    }

    public NetworkRequest convert(T value) throws IOException {
        byte[] bytes = this.adapter.writeValueAsBytes(value);
        return new NetworkRequest.Builder().setContentType(MEDIA_TYPE).setBody(bytes).build();
    }
}

