/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.Request;
import io.apptik.comm.jus.converter.JacksonRequestConverter;
import io.apptik.comm.jus.converter.JacksonResponseConverter;
import io.apptik.comm.jus.http.HttpUrl;
import java.io.IOException;

public class JacksonRequest<T>
extends Request<T> {
    public JacksonRequest(String method, HttpUrl url, ObjectReader adapter) {
        super(method, url, new JacksonResponseConverter(adapter));
        this.setNetworkRequest(NetworkRequest.Builder.from((NetworkRequest)this.getNetworkRequest()).addHeader("Accept", "application/json").build());
    }

    public JacksonRequest(String method, HttpUrl url, ObjectMapper objectMapper) {
        this(method, url, objectMapper.reader());
    }

    public JacksonRequest(String method, HttpUrl url, ObjectMapper objectMapper, Class<T> tClass) {
        this(method, url, objectMapper.readerFor(tClass));
    }

    public JacksonRequest(String method, HttpUrl url) {
        this(method, url, new ObjectMapper());
    }

    public JacksonRequest(String method, HttpUrl url, Class<T> tClass) {
        this(method, url, new ObjectMapper(), tClass);
    }

    public JacksonRequest(String method, String url, ObjectReader adapter) {
        super(method, url, new JacksonResponseConverter(adapter));
        this.setNetworkRequest(NetworkRequest.Builder.from((NetworkRequest)this.getNetworkRequest()).addHeader("Accept", "application/json").build());
    }

    public JacksonRequest(String method, String url, ObjectMapper objectMapper) {
        this(method, url, objectMapper.reader());
    }

    public JacksonRequest(String method, String url, ObjectMapper objectMapper, Class<T> tClass) {
        this(method, url, objectMapper.readerFor(tClass));
    }

    public JacksonRequest(String method, String url) {
        this(method, url, new ObjectMapper());
    }

    public JacksonRequest(String method, String url, Class<T> tClass) {
        this(method, url, new ObjectMapper(), tClass);
    }

    public <R> JacksonRequest<T> setRequestData(R requestData, ObjectWriter adapter) {
        try {
            super.setRequestData(requestData, new JacksonRequestConverter(adapter));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert " + requestData + " to NetworkRequest", e);
        }
        this.setNetworkRequest(NetworkRequest.Builder.from((NetworkRequest)this.getNetworkRequest()).setHeader("Accept", "application/json").build());
        return this;
    }

    public <R> JacksonRequest<T> setRequestData(R requestData, ObjectMapper objectMapper) {
        return this.setRequestData(requestData, objectMapper.writerFor(requestData.getClass()));
    }

    public <R> JacksonRequest<T> setRequestData(R requestData) {
        return this.setRequestData(requestData, new ObjectMapper());
    }
}

