/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.converter;

import com.fasterxml.jackson.databind.ObjectReader;
import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.toolbox.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public final class JacksonResponseConverter<T>
implements Converter<NetworkResponse, T> {
    private final ObjectReader adapter;

    public JacksonResponseConverter(ObjectReader adapter) {
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T convert(NetworkResponse value) throws IOException {
        if (value.statusCode == 204 || value.statusCode == 205) {
            return null;
        }
        InputStreamReader reader = value.getCharStream();
        try {
            Object object = this.adapter.readValue((Reader)reader);
            return (T)object;
        }
        finally {
            Utils.closeQuietly((Closeable)reader);
        }
    }
}

