/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.okhttp3;

import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.http.Headers;
import java.util.Collections;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class JusOk {
    private JusOk() {
    }

    public static Headers jusHeaders(okhttp3.Headers okHeaders) {
        return Headers.ofMMap((Map)okHeaders.toMultimap());
    }

    public static okhttp3.Headers okHeaders(Headers jusHeaders, Headers additionalHeaders) {
        Map headers;
        if (jusHeaders == null) {
            headers = Collections.emptyMap();
        } else {
            headers = jusHeaders.toMap();
            headers.remove("Content-Type");
        }
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders.toMap());
        }
        return okhttp3.Headers.of((Map)headers);
    }

    public static RequestBody okBody(NetworkRequest request) {
        if (request == null || request.contentType == null && request.data == null) {
            return null;
        }
        MediaType mediaType = null;
        if (request.contentType != null) {
            mediaType = MediaType.parse((String)request.contentType.toString());
        }
        return RequestBody.create(mediaType, (byte[])request.data);
    }
}

