/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.okhttp3;

import io.apptik.comm.jus.NetworkDispatcher;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.Request;
import io.apptik.comm.jus.http.Headers;
import io.apptik.comm.jus.okhttp3.JusOk;
import io.apptik.comm.jus.stack.AbstractHttpStack;
import io.apptik.comm.jus.toolbox.ByteArrayPool;
import io.apptik.comm.jus.toolbox.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;

public class OkHttpStack
extends AbstractHttpStack {
    private final OkHttpClient client;

    public OkHttpStack() {
        this(new OkHttpClient());
    }

    public OkHttpStack(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException("Client must not be null.");
        }
        this.client = client;
    }

    public NetworkResponse performRequest(Request<?> request, Headers additionalHeaders, ByteArrayPool byteArrayPool) throws IOException {
        OkHttpClient client = this.client.newBuilder().connectTimeout((long)request.getRetryPolicy().getCurrentConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)request.getRetryPolicy().getCurrentReadTimeout(), TimeUnit.MILLISECONDS).build();
        okhttp3.Request okRequest = new Request.Builder().url(request.getUrlString()).headers(JusOk.okHeaders(request.getHeaders(), additionalHeaders)).tag(request.getTag()).method(request.getMethod(), JusOk.okBody(request.getNetworkRequest())).build();
        long requestStart = System.nanoTime();
        Response response = client.newCall(okRequest).execute();
        byte[] data = null;
        data = NetworkDispatcher.hasResponseBody((String)request.getMethod(), (int)response.code()) ? this.getContentBytes(response.body().source(), byteArrayPool, (int)response.body().contentLength()) : new byte[]{};
        return new NetworkResponse.Builder().setHeaders(JusOk.jusHeaders(response.headers())).setStatusCode(response.code()).setBody(data).setNetworkTimeNs(System.nanoTime() - requestStart).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getContentBytes(BufferedSource bufferedSource, ByteArrayPool byteArrayPool, int contentLen) throws IOException {
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(byteArrayPool, contentLen);
        byte[] buffer = null;
        try {
            block14: {
                if (bufferedSource == null) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                buffer = byteArrayPool.getBuf(1024);
                try {
                    int count;
                    while ((count = bufferedSource.read(buffer)) != -1) {
                        bytes.write(buffer, 0, count);
                    }
                }
                catch (IOException ex) {
                    if (!(ex instanceof SocketTimeoutException)) break block14;
                    throw ex;
                }
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        finally {
            try {
                bufferedSource.close();
            }
            catch (IOException iOException) {}
            byteArrayPool.returnBuf(buffer);
            bytes.close();
        }
    }
}

