/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.okhttp3;

import io.apptik.comm.jus.Request;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public abstract class AbstractMarkerInterceptor
implements Interceptor {
    public static final String OKHTTP3_INTERCEPT = "okhttp3-intercept";
    public static final String OKHTTP3_ERROR = "okhttp3-error";
    final Request<?> request;

    public AbstractMarkerInterceptor(Request<?> request) {
        this.request = request;
    }

    abstract Object[] getMarkerArgs(Request<?> var1, okhttp3.Request var2);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        okhttp3.Request okhttpRequest = chain.request();
        this.request.addMarker(OKHTTP3_INTERCEPT, this.getMarkerArgs(this.request, okhttpRequest));
        try {
            response = chain.proceed(okhttpRequest);
        }
        catch (Exception e) {
            this.request.addMarker(OKHTTP3_ERROR, new Object[]{e});
            throw e;
        }
        return response;
    }
}

