/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.retro;

import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.RequestQueue;
import io.apptik.comm.jus.retro.RequestFactory;
import io.apptik.comm.jus.retro.RequestFactoryParser;
import io.apptik.comm.jus.retro.RetroProxy;
import io.apptik.comm.jus.retro.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

final class MethodHandler<T> {
    private final RequestQueue requestQueue;
    private final RequestFactory requestFactory;
    private final Converter<NetworkResponse, T> responseConverter;

    static MethodHandler<?> create(RetroProxy retroProxy, Method method) {
        Type responseType = method.getGenericReturnType();
        if (Utils.hasUnresolvableType(responseType = Utils.getRequestResponseType(responseType))) {
            throw Utils.methodError(method, "Method return type must not include a type variable or wildcard: %s", responseType);
        }
        if (responseType == Void.TYPE) {
            throw Utils.methodError(method, "Service methods cannot return void.", new Object[0]);
        }
        Annotation[] annotations = method.getAnnotations();
        Converter<NetworkResponse, ?> responseConverter = MethodHandler.createResponseConverter(method, retroProxy, responseType);
        RequestFactory requestFactory = RequestFactoryParser.parse(method, retroProxy);
        return new MethodHandler(retroProxy.requestQueue(), requestFactory, responseConverter);
    }

    private static Converter<NetworkResponse, ?> createResponseConverter(Method method, RetroProxy retroProxy, Type responseType) {
        Annotation[] annotations = method.getAnnotations();
        try {
            return retroProxy.responseConverter(responseType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(e, method, "Unable to create converter for %s", responseType);
        }
    }

    private MethodHandler(RequestQueue requestQueue, RequestFactory requestFactory, Converter<NetworkResponse, T> responseConverter) {
        this.requestQueue = requestQueue;
        this.requestFactory = requestFactory;
        this.responseConverter = responseConverter;
    }

    Object invoke(Object ... args) {
        return this.requestQueue.add(this.requestFactory.create(this.responseConverter, args));
    }
}

