/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.retro;

import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.Request;
import io.apptik.comm.jus.http.Headers;
import io.apptik.comm.jus.http.HttpUrl;
import io.apptik.comm.jus.http.MediaType;
import io.apptik.comm.jus.retro.RequestBuilderAction;
import io.apptik.comm.jus.retro.RequestFactory;
import io.apptik.comm.jus.retro.RetroProxy;
import io.apptik.comm.jus.retro.Utils;
import io.apptik.comm.jus.retro.http.Body;
import io.apptik.comm.jus.retro.http.DELETE;
import io.apptik.comm.jus.retro.http.Field;
import io.apptik.comm.jus.retro.http.FieldMap;
import io.apptik.comm.jus.retro.http.FormUrlEncoded;
import io.apptik.comm.jus.retro.http.GET;
import io.apptik.comm.jus.retro.http.HEAD;
import io.apptik.comm.jus.retro.http.HTTP;
import io.apptik.comm.jus.retro.http.Header;
import io.apptik.comm.jus.retro.http.Headers;
import io.apptik.comm.jus.retro.http.Multipart;
import io.apptik.comm.jus.retro.http.PATCH;
import io.apptik.comm.jus.retro.http.POST;
import io.apptik.comm.jus.retro.http.PUT;
import io.apptik.comm.jus.retro.http.Part;
import io.apptik.comm.jus.retro.http.PartMap;
import io.apptik.comm.jus.retro.http.Path;
import io.apptik.comm.jus.retro.http.Priority;
import io.apptik.comm.jus.retro.http.Query;
import io.apptik.comm.jus.retro.http.QueryMap;
import io.apptik.comm.jus.retro.http.ShouldCache;
import io.apptik.comm.jus.retro.http.Tag;
import io.apptik.comm.jus.retro.http.Url;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RequestFactoryParser {
    private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
    private final Method method;
    private String httpMethod;
    private boolean hasBody;
    private boolean isFormEncoded;
    private boolean isMultipart;
    private String relativeUrl;
    private io.apptik.comm.jus.http.Headers headers;
    private MediaType contentType;
    private RequestBuilderAction[] requestBuilderActions;
    private Set<String> relativeUrlParamNames;
    private Request.Priority priority = Request.Priority.NORMAL;
    private String tag;
    private boolean shouldCache = true;

    static RequestFactory parse(Method method, RetroProxy retroProxy) {
        RequestFactoryParser parser = new RequestFactoryParser(method);
        parser.parseMethodAnnotations();
        parser.parseParameters(retroProxy);
        return parser.toRequestFactory(retroProxy.baseUrl());
    }

    private RequestFactoryParser(Method method) {
        this.method = method;
    }

    private RequestFactory toRequestFactory(HttpUrl baseUrl) {
        return new RequestFactory(this.httpMethod, baseUrl, this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart, this.requestBuilderActions, this.priority, this.tag, this.shouldCache);
    }

    private RuntimeException parameterError(Throwable cause, int index, String message, Object ... args) {
        return Utils.methodError(cause, this.method, message + " (parameter #" + (index + 1) + ")", args);
    }

    private RuntimeException parameterError(int index, String message, Object ... args) {
        return Utils.methodError(this.method, message + " (parameter #" + (index + 1) + ")", args);
    }

    private void parseMethodAnnotations() {
        for (Annotation annotation : this.method.getAnnotations()) {
            if (annotation instanceof DELETE) {
                this.parseHttpMethodAndPath("DELETE", ((DELETE)annotation).value(), false);
                continue;
            }
            if (annotation instanceof GET) {
                this.parseHttpMethodAndPath("GET", ((GET)annotation).value(), false);
                continue;
            }
            if (annotation instanceof HEAD) {
                this.parseHttpMethodAndPath("HEAD", ((HEAD)annotation).value(), false);
                continue;
            }
            if (annotation instanceof PATCH) {
                this.parseHttpMethodAndPath("PATCH", ((PATCH)annotation).value(), true);
                continue;
            }
            if (annotation instanceof POST) {
                this.parseHttpMethodAndPath("POST", ((POST)annotation).value(), true);
                continue;
            }
            if (annotation instanceof PUT) {
                this.parseHttpMethodAndPath("PUT", ((PUT)annotation).value(), true);
                continue;
            }
            if (annotation instanceof HTTP) {
                HTTP http = (HTTP)annotation;
                this.parseHttpMethodAndPath(http.method(), http.path(), http.hasBody());
                continue;
            }
            if (annotation instanceof Headers) {
                String[] headersToParse = ((Headers)annotation).value();
                if (headersToParse.length == 0) {
                    throw Utils.methodError(this.method, "@Headers annotation is empty.", new Object[0]);
                }
                this.headers = this.parseHeaders(headersToParse);
                continue;
            }
            if (annotation instanceof Multipart) {
                if (this.isFormEncoded) {
                    throw Utils.methodError(this.method, "Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isMultipart = true;
                continue;
            }
            if (annotation instanceof FormUrlEncoded) {
                if (this.isMultipart) {
                    throw Utils.methodError(this.method, "Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isFormEncoded = true;
                continue;
            }
            if (annotation instanceof Priority) {
                this.priority = ((Priority)annotation).value();
                continue;
            }
            if (annotation instanceof Tag) {
                this.tag = ((Tag)annotation).value();
                continue;
            }
            if (!(annotation instanceof ShouldCache)) continue;
            this.shouldCache = ((ShouldCache)annotation).value();
        }
        if (this.httpMethod == null) {
            throw Utils.methodError(this.method, "HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
        }
        if (!this.hasBody) {
            if (this.isMultipart) {
                throw Utils.methodError(this.method, "Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
            if (this.isFormEncoded) {
                throw Utils.methodError(this.method, "FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
        }
    }

    private void parseHttpMethodAndPath(String httpMethod, String value, boolean hasBody) {
        String queryParams;
        Matcher queryParamMatcher;
        if (this.httpMethod != null) {
            throw Utils.methodError(this.method, "Only one HTTP method is allowed. Found: %s and %s.", this.httpMethod, httpMethod);
        }
        this.httpMethod = httpMethod;
        this.hasBody = hasBody;
        if (value.isEmpty()) {
            return;
        }
        int question = value.indexOf(63);
        if (question != -1 && question < value.length() - 1 && (queryParamMatcher = PARAM_URL_REGEX.matcher(queryParams = value.substring(question + 1))).find()) {
            throw Utils.methodError(this.method, "URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", queryParams);
        }
        this.relativeUrl = value;
        this.relativeUrlParamNames = RequestFactoryParser.parsePathParameters(value);
    }

    private io.apptik.comm.jus.http.Headers parseHeaders(String[] headers) {
        Headers.Builder builder = new Headers.Builder();
        for (String header : headers) {
            int colon = header.indexOf(58);
            if (colon == -1 || colon == 0 || colon == header.length() - 1) {
                throw Utils.methodError(this.method, "@Headers value must be in the form \"Name: Value\". Found: \"%s\"", header);
            }
            String headerName = header.substring(0, colon);
            String headerValue = header.substring(colon + 1).trim();
            if ("Content-Type".equalsIgnoreCase(headerName)) {
                this.contentType = MediaType.parse((String)headerValue);
                continue;
            }
            builder.add(headerName, headerValue);
        }
        return builder.build();
    }

    private void parseParameters(RetroProxy retroProxy) {
        Type[] methodParameterTypes = this.method.getGenericParameterTypes();
        Annotation[][] methodParameterAnnotationArrays = this.method.getParameterAnnotations();
        boolean gotField = false;
        boolean gotPart = false;
        boolean gotBody = false;
        boolean gotPath = false;
        boolean gotQuery = false;
        boolean gotUrl = false;
        int count = methodParameterAnnotationArrays.length;
        RequestBuilderAction[] requestBuilderActions = new RequestBuilderAction[count];
        for (int i = 0; i < count; ++i) {
            Type methodParameterType = methodParameterTypes[i];
            Annotation[] methodParameterAnnotations = methodParameterAnnotationArrays[i];
            if (methodParameterAnnotations != null) {
                for (Annotation methodParameterAnnotation : methodParameterAnnotations) {
                    RequestBuilderAction action = null;
                    if (methodParameterAnnotation instanceof Url) {
                        if (gotUrl) {
                            throw this.parameterError(i, "Multiple @Url method annotations found.", new Object[0]);
                        }
                        if (gotPath) {
                            throw this.parameterError(i, "@Path parameters may not be used with @Url.", new Object[0]);
                        }
                        if (gotQuery) {
                            throw this.parameterError(i, "A @Url parameter must not come after a @Query", new Object[0]);
                        }
                        if (methodParameterType != String.class) {
                            throw this.parameterError(i, "@Url must be String type.", new Object[0]);
                        }
                        if (this.relativeUrl != null) {
                            throw this.parameterError(i, "@Url cannot be used with @%s URL", this.httpMethod);
                        }
                        gotUrl = true;
                        action = new RequestBuilderAction.Url();
                    } else if (methodParameterAnnotation instanceof Path) {
                        if (gotQuery) {
                            throw this.parameterError(i, "A @Path parameter must not come after a @Query.", new Object[0]);
                        }
                        if (gotUrl) {
                            throw this.parameterError(i, "@Path parameters may not be used with @Url.", new Object[0]);
                        }
                        if (this.relativeUrl == null) {
                            throw this.parameterError(i, "@Path can only be used with relative url on @%s", this.httpMethod);
                        }
                        gotPath = true;
                        Path path = (Path)methodParameterAnnotation;
                        String name = path.value();
                        this.validatePathName(i, name);
                        action = new RequestBuilderAction.Path(name, path.encoded());
                    } else if (methodParameterAnnotation instanceof Query) {
                        Query query = (Query)methodParameterAnnotation;
                        action = new RequestBuilderAction.Query(query.value(), query.encoded());
                        gotQuery = true;
                    } else if (methodParameterAnnotation instanceof QueryMap) {
                        if (!Map.class.isAssignableFrom(Utils.getRawType(methodParameterType))) {
                            throw this.parameterError(i, "@QueryMap parameter type must be Map.", new Object[0]);
                        }
                        QueryMap queryMap = (QueryMap)methodParameterAnnotation;
                        action = new RequestBuilderAction.QueryMap(queryMap.encoded());
                    } else if (methodParameterAnnotation instanceof Header) {
                        Header header = (Header)methodParameterAnnotation;
                        action = new RequestBuilderAction.Header(header.value());
                    } else if (methodParameterAnnotation instanceof Field) {
                        if (!this.isFormEncoded) {
                            throw this.parameterError(i, "@Field parameters can only be used with form encoding.", new Object[0]);
                        }
                        Field field = (Field)methodParameterAnnotation;
                        action = new RequestBuilderAction.Field(field.value(), field.encoded());
                        gotField = true;
                    } else if (methodParameterAnnotation instanceof FieldMap) {
                        if (!this.isFormEncoded) {
                            throw this.parameterError(i, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
                        }
                        if (!Map.class.isAssignableFrom(Utils.getRawType(methodParameterType))) {
                            throw this.parameterError(i, "@FieldMap parameter type must be Map.", new Object[0]);
                        }
                        FieldMap fieldMap = (FieldMap)methodParameterAnnotation;
                        action = new RequestBuilderAction.FieldMap(fieldMap.encoded());
                        gotField = true;
                    } else if (methodParameterAnnotation instanceof Part) {
                        Converter<?, NetworkRequest> converter;
                        if (!this.isMultipart) {
                            throw this.parameterError(i, "@Part parameters can only be used with multipart encoding.", new Object[0]);
                        }
                        Part part = (Part)methodParameterAnnotation;
                        io.apptik.comm.jus.http.Headers headers = new Headers.Builder().add("Content-Disposition", "form-data; name=\"" + part.value() + "\"").add("Content-Transfer-Encoding", part.encoding()).build();
                        try {
                            converter = retroProxy.requestConverter(methodParameterType, methodParameterAnnotations);
                        }
                        catch (RuntimeException e) {
                            throw this.parameterError(e, i, "Unable to create @Part converter for %s", methodParameterType);
                        }
                        action = new RequestBuilderAction.Part(headers, converter);
                        gotPart = true;
                    } else if (methodParameterAnnotation instanceof PartMap) {
                        if (!this.isMultipart) {
                            throw this.parameterError(i, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
                        }
                        if (!Map.class.isAssignableFrom(Utils.getRawType(methodParameterType))) {
                            throw this.parameterError(i, "@PartMap parameter type must be Map.", new Object[0]);
                        }
                        PartMap partMap = (PartMap)methodParameterAnnotation;
                        action = new RequestBuilderAction.PartMap(retroProxy, partMap.encoding(), methodParameterAnnotations);
                        gotPart = true;
                    } else if (methodParameterAnnotation instanceof Body) {
                        Converter<?, NetworkRequest> converter;
                        if (this.isFormEncoded || this.isMultipart) {
                            throw this.parameterError(i, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
                        }
                        if (gotBody) {
                            throw this.parameterError(i, "Multiple @Body method annotations found.", new Object[0]);
                        }
                        try {
                            converter = retroProxy.requestConverter(methodParameterType, methodParameterAnnotations);
                        }
                        catch (RuntimeException e) {
                            throw this.parameterError(e, i, "Unable to create @Body converter for %s", methodParameterType);
                        }
                        action = new RequestBuilderAction.Body(converter);
                        gotBody = true;
                    }
                    if (action == null) continue;
                    if (requestBuilderActions[i] != null) {
                        throw this.parameterError(i, "Multiple Retrofit annotations found, only one allowed.", new Object[0]);
                    }
                    requestBuilderActions[i] = action;
                }
            }
            if (requestBuilderActions[i] != null) continue;
            throw this.parameterError(i, "No Retrofit annotation found.", new Object[0]);
        }
        if (this.relativeUrl == null && !gotUrl) {
            throw Utils.methodError(this.method, "Missing either @%s URL or @Url parameter.", this.httpMethod);
        }
        if (!this.isFormEncoded && !this.isMultipart && !this.hasBody && gotBody) {
            throw Utils.methodError(this.method, "Non-body HTTP method cannot contain @Body.", new Object[0]);
        }
        if (this.isFormEncoded && !gotField) {
            throw Utils.methodError(this.method, "Form-encoded method must contain at least one @Field.", new Object[0]);
        }
        if (this.isMultipart && !gotPart) {
            throw Utils.methodError(this.method, "Multipart method must contain at least one @Part.", new Object[0]);
        }
        this.requestBuilderActions = requestBuilderActions;
    }

    private void validatePathName(int index, String name) {
        if (!PARAM_NAME_REGEX.matcher(name).matches()) {
            throw this.parameterError(index, "@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), name);
        }
        if (!this.relativeUrlParamNames.contains(name)) {
            throw this.parameterError(index, "URL \"%s\" does not contain \"{%s}\".", this.relativeUrl, name);
        }
    }

    static Set<String> parsePathParameters(String path) {
        Matcher m = PARAM_URL_REGEX.matcher(path);
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        while (m.find()) {
            patterns.add(m.group(1));
        }
        return patterns;
    }
}

