/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.retro;

import io.apptik.comm.jus.Request;
import io.apptik.comm.jus.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

final class Utils {
    static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> cls) {
        for (Annotation annotation : annotations) {
            if (!cls.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    static <T> void validateServiceInterface(Class<T> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("API declarations must be interfaces.");
        }
        if (service.getInterfaces().length > 0) {
            throw new IllegalArgumentException("API interfaces must not extend other interfaces.");
        }
    }

    public static Type getParameterUpperBound(ParameterizedType type) {
        Object[] types = type.getActualTypeArguments();
        if (types.length != 1) {
            throw new IllegalArgumentException("Expected one type argument but got: " + Arrays.toString(types));
        }
        Type paramType = types[0];
        if (paramType instanceof WildcardType) {
            return ((WildcardType)paramType).getUpperBounds()[0];
        }
        return paramType;
    }

    public static Type getSecondParameterUpperBound(ParameterizedType type) {
        Object[] types = type.getActualTypeArguments();
        if (types.length != 2) {
            throw new IllegalArgumentException("Expected one type argument but got: " + Arrays.toString(types));
        }
        Type paramType = types[1];
        if (paramType instanceof WildcardType) {
            return ((WildcardType)paramType).getUpperBounds()[0];
        }
        return paramType;
    }

    public static boolean hasUnresolvableType(Type type) {
        if (type instanceof Class) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (!Utils.hasUnresolvableType(typeArgument)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return Utils.hasUnresolvableType(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof WildcardType) {
            return true;
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalArgumentException();
            }
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Utils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Utils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static boolean checkIfRequestRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType() == Request.class;
        }
        return false;
    }

    static RuntimeException methodError(Method method, String message, Object ... args) {
        return Utils.methodError(null, method, message, args);
    }

    static RuntimeException methodError(Throwable cause, Method method, String message, Object ... args) {
        message = String.format(message, args);
        IllegalArgumentException e = new IllegalArgumentException(message + "\n    for method " + method.getDeclaringClass().getSimpleName() + "." + method.getName());
        e.initCause(cause);
        return e;
    }

    static Type getRequestResponseType(Type returnType) {
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Request return type must be parameterized as Request<Foo> or Request<? extends Foo>");
        }
        Type responseType = Utils.getParameterUpperBound((ParameterizedType)returnType);
        if (Utils.getRawType(responseType) == Response.class) {
            throw new IllegalArgumentException("Request<T> cannot use Response as its generic parameter. Specify the response body type only (e.g., Request<TweetResponse>).");
        }
        return responseType;
    }

    private Utils() {
    }
}

