/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.retro;

import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.Request;
import io.apptik.comm.jus.RequestBuilder;
import io.apptik.comm.jus.http.Headers;
import io.apptik.comm.jus.http.HttpUrl;
import io.apptik.comm.jus.http.MediaType;
import io.apptik.comm.jus.retro.RequestBuilderAction;

final class RequestFactory {
    private final String method;
    private final HttpUrl baseUrl;
    private final String relativeUrl;
    private final Headers headers;
    private final MediaType contentType;
    private final boolean hasBody;
    private final boolean isFormEncoded;
    private final boolean isMultipart;
    private final RequestBuilderAction[] requestBuilderActions;
    private final Request.Priority priority;
    private final String tag;
    private final boolean shouldCache;

    RequestFactory(String method, HttpUrl baseUrl, String relativeUrl, Headers headers, MediaType contentType, boolean hasBody, boolean isFormEncoded, boolean isMultipart, RequestBuilderAction[] requestBuilderActions, Request.Priority priority, String tag, boolean shouldCache) {
        this.method = method;
        this.baseUrl = baseUrl;
        this.relativeUrl = relativeUrl;
        this.headers = headers;
        this.contentType = contentType;
        this.hasBody = hasBody;
        this.isFormEncoded = isFormEncoded;
        this.isMultipart = isMultipart;
        this.requestBuilderActions = requestBuilderActions;
        this.priority = priority;
        this.tag = tag;
        this.shouldCache = shouldCache;
    }

    Request create(Converter<NetworkResponse, ?> responseConverter, Object ... args) {
        RequestBuilder requestBuilder = new RequestBuilder(this.method, this.baseUrl, this.relativeUrl, responseConverter, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart, this.priority, this.tag, this.shouldCache);
        if (args != null) {
            RequestBuilderAction[] actions = this.requestBuilderActions;
            if (actions.length != args.length) {
                throw new IllegalArgumentException("Argument count (" + args.length + ") doesn't match action count (" + actions.length + ")");
            }
            int count = args.length;
            for (int i = 0; i < count; ++i) {
                actions[i].perform(requestBuilder, args[i]);
            }
        }
        return requestBuilder.build();
    }
}

