/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.retro;

import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.RequestBuilder;
import io.apptik.comm.jus.http.Headers;
import io.apptik.comm.jus.retro.RetroProxy;
import io.apptik.comm.jus.toolbox.Utils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;

abstract class RequestBuilderAction {
    RequestBuilderAction() {
    }

    abstract void perform(RequestBuilder var1, Object var2);

    static final class Body<T>
    extends RequestBuilderAction {
        private final Converter<T, NetworkRequest> converter;

        Body(Converter<T, NetworkRequest> converter) {
            this.converter = converter;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            NetworkRequest networkRequest;
            if (value == null) {
                throw new IllegalArgumentException("Body parameter value must not be null.");
            }
            try {
                networkRequest = (NetworkRequest)this.converter.convert(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert " + value + " to NetworkRequest", e);
            }
            builder.setBody(networkRequest.data);
            if (networkRequest.headers != null) {
                for (Map.Entry header : networkRequest.headers.toMap().entrySet()) {
                    if (builder.hasContentTypeSet() && "Content-Type".equals(header.getKey())) continue;
                    builder.addHeader((String)header.getKey(), (String)header.getValue());
                }
            }
        }
    }

    static final class PartMap
    extends RequestBuilderAction {
        private final RetroProxy retroProxy;
        private final String transferEncoding;
        private final Annotation[] annotations;

        PartMap(RetroProxy retroProxy, String transferEncoding, Annotation[] annotations) {
            this.retroProxy = retroProxy;
            this.transferEncoding = transferEncoding;
            this.annotations = annotations;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                NetworkRequest body;
                Object entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Part map contained null key.");
                }
                Object entryValue = entry.getValue();
                if (entryValue == null) continue;
                Headers headers = new Headers.Builder().add("Content-Disposition", "form-data; name=\"" + entryKey + "\"").add("Content-Transfer-Encoding", this.transferEncoding).build();
                Class<?> entryClass = entryValue.getClass();
                Converter<?, NetworkRequest> converter = this.retroProxy.requestConverter(entryClass, this.annotations);
                try {
                    body = (NetworkRequest)converter.convert(entryValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to convert " + entryValue + " to Request");
                }
                body = new NetworkRequest.Builder().setBody(body.data).setHeaders(body.headers).addHeaders(headers).build();
                builder.addPart(body);
            }
        }
    }

    static final class Part<T>
    extends RequestBuilderAction {
        private final Converter<T, NetworkRequest> converter;
        private final Headers headers;

        Part(Headers headers, Converter<T, NetworkRequest> converter) {
            this.converter = converter;
            this.headers = headers;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            NetworkRequest body;
            if (value == null) {
                return;
            }
            try {
                body = (NetworkRequest)this.converter.convert(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert " + value + " to Request");
            }
            body = new NetworkRequest.Builder().setBody(body.data).setHeaders(body.headers).addHeaders(this.headers).build();
            builder.addPart(body);
        }
    }

    static final class FieldMap
    extends RequestBuilderAction {
        private final boolean encoded;

        FieldMap(boolean encoded) {
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Field map contained null key.");
                }
                Object entryValue = entry.getValue();
                if (entryValue == null) continue;
                builder.addFormField(entryKey.toString(), entryValue.toString(), this.encoded);
            }
        }
    }

    static final class Field
    extends RequestBuilderAction {
        private final String name;
        private final boolean encoded;

        Field(String name, boolean encoded) {
            this.name = (String)Utils.checkNotNull((Object)name, (String)"name == null");
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Iterable) {
                for (Object iterableValue : (Iterable)value) {
                    if (iterableValue == null) continue;
                    builder.addFormField(this.name, iterableValue.toString(), this.encoded);
                }
            } else if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int x = 0; x < arrayLength; ++x) {
                    Object arrayValue = Array.get(value, x);
                    if (arrayValue == null) continue;
                    builder.addFormField(this.name, arrayValue.toString(), this.encoded);
                }
            } else {
                builder.addFormField(this.name, value.toString(), this.encoded);
            }
        }
    }

    static final class QueryMap
    extends RequestBuilderAction {
        private final boolean encoded;

        QueryMap(boolean encoded) {
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Query map contained null key.");
                }
                Object entryValue = entry.getValue();
                if (entryValue == null) continue;
                builder.addQueryParam(entryKey.toString(), entryValue.toString(), this.encoded);
            }
        }
    }

    static final class Query
    extends RequestBuilderAction {
        private final String name;
        private final boolean encoded;

        Query(String name, boolean encoded) {
            this.name = (String)Utils.checkNotNull((Object)name, (String)"name == null");
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Iterable) {
                for (Object iterableValue : (Iterable)value) {
                    if (iterableValue == null) continue;
                    builder.addQueryParam(this.name, iterableValue.toString(), this.encoded);
                }
            } else if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int x = 0; x < arrayLength; ++x) {
                    Object arrayValue = Array.get(value, x);
                    if (arrayValue == null) continue;
                    builder.addQueryParam(this.name, arrayValue.toString(), this.encoded);
                }
            } else {
                builder.addQueryParam(this.name, value.toString(), this.encoded);
            }
        }
    }

    static final class Path
    extends RequestBuilderAction {
        private final String name;
        private final boolean encoded;

        Path(String name, boolean encoded) {
            this.name = (String)Utils.checkNotNull((Object)name, (String)"name == null");
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Path parameter \"" + this.name + "\" value must not be null.");
            }
            builder.addPathParam(this.name, value.toString(), this.encoded);
        }
    }

    static final class Header
    extends RequestBuilderAction {
        private final String name;

        Header(String name) {
            this.name = (String)Utils.checkNotNull((Object)name, (String)"name == null");
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Iterable) {
                for (Object iterableValue : (Iterable)value) {
                    if (iterableValue == null) continue;
                    builder.addHeader(this.name, iterableValue.toString());
                }
            } else if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int x = 0; x < arrayLength; ++x) {
                    Object arrayValue = Array.get(value, x);
                    if (arrayValue == null) continue;
                    builder.addHeader(this.name, arrayValue.toString());
                }
            } else {
                builder.addHeader(this.name, value.toString());
            }
        }
    }

    static final class ShouldCache
    extends RequestBuilderAction {
        ShouldCache() {
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            builder.setShouldCache(value);
        }
    }

    static final class Priority
    extends RequestBuilderAction {
        Priority() {
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            builder.setPriority(value);
        }
    }

    static final class Tag
    extends RequestBuilderAction {
        Tag() {
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            if (value == null) {
                return;
            }
            builder.setTag(value);
        }
    }

    static final class Url
    extends RequestBuilderAction {
        Url() {
        }

        @Override
        void perform(RequestBuilder builder, Object value) {
            builder.setRelativeUrl((String)value);
        }
    }
}

