/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.comm.jus.retro;

import io.apptik.comm.jus.Converter;
import io.apptik.comm.jus.Jus;
import io.apptik.comm.jus.NetworkRequest;
import io.apptik.comm.jus.NetworkResponse;
import io.apptik.comm.jus.RequestQueue;
import io.apptik.comm.jus.converter.BasicConverterFactory;
import io.apptik.comm.jus.http.HttpUrl;
import io.apptik.comm.jus.retro.MethodHandler;
import io.apptik.comm.jus.retro.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RetroProxy {
    private final Map<Method, MethodHandler<?>> methodHandlerCache = new LinkedHashMap();
    private final RequestQueue requestQueue;
    private final HttpUrl baseUrl;
    private final List<Converter.Factory> converters;
    private final boolean validateEagerly;
    private final boolean execManually;

    private RetroProxy(RequestQueue requestQueue, HttpUrl baseUrl, List<Converter.Factory> converters, boolean validateEagerly, boolean execManually) {
        this.requestQueue = requestQueue;
        this.baseUrl = baseUrl;
        this.converters = converters;
        this.validateEagerly = validateEagerly;
        this.execManually = execManually;
    }

    public <T> T create(Class<T> service) {
        Utils.validateServiceInterface(service);
        if (this.validateEagerly) {
            this.eagerlyValidateMethods(service);
        }
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return RetroProxy.this.loadMethodHandler(method).invoke(args);
            }
        });
    }

    private void eagerlyValidateMethods(Class<?> service) {
        for (Method method : service.getDeclaredMethods()) {
            this.loadMethodHandler(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodHandler<?> loadMethodHandler(Method method) {
        MethodHandler<?> handler;
        Map<Method, MethodHandler<?>> map = this.methodHandlerCache;
        synchronized (map) {
            handler = this.methodHandlerCache.get(method);
            if (handler == null) {
                handler = MethodHandler.create(this, method);
                this.methodHandlerCache.put(method, handler);
            }
        }
        return handler;
    }

    public RequestQueue requestQueue() {
        return this.requestQueue;
    }

    public boolean execManually() {
        return this.execManually;
    }

    public HttpUrl baseUrl() {
        return this.baseUrl;
    }

    public List<Converter.Factory> converterFactories() {
        return Collections.unmodifiableList(this.converters);
    }

    public Converter<?, NetworkRequest> requestConverter(Type type, Annotation[] annotations) {
        io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)type, (String)"type == null");
        io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)annotations, (String)"annotations == null");
        int count = this.converters.size();
        for (int i = 0; i < count; ++i) {
            Converter converter = this.converters.get(i).toRequest(type, annotations);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate Request converter for ").append(type).append(". Tried:");
        for (Converter.Factory converterFactory : this.converters) {
            builder.append("\n * ").append(converterFactory.getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public Converter<NetworkResponse, ?> responseConverter(Type type, Annotation[] annotations) {
        io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)type, (String)"type == null");
        io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)annotations, (String)"annotations == null");
        int count = this.converters.size();
        for (int i = 0; i < count; ++i) {
            Converter converter = this.converters.get(i).fromResponse(type, annotations);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate Response converter for ").append(type).append(". Tried:");
        for (Converter.Factory converterFactory : this.converters) {
            builder.append("\n * ").append(converterFactory.getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public static final class Builder {
        private RequestQueue requestQueue;
        private HttpUrl baseUrl;
        private List<Converter.Factory> converters = new ArrayList<Converter.Factory>();
        private boolean validateEagerly = false;
        private boolean execManually = false;

        public Builder() {
            this.converters.add((Converter.Factory)new BasicConverterFactory());
        }

        public Builder requestQueue(RequestQueue requestQueue) {
            this.requestQueue = (RequestQueue)io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)requestQueue, (String)"requestQueue == null");
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)baseUrl, (String)"baseUrl == null");
            HttpUrl httpUrl = HttpUrl.parse((String)baseUrl);
            if (httpUrl == null) {
                throw new IllegalArgumentException("Illegal URL: " + baseUrl);
            }
            return this.baseUrl(httpUrl);
        }

        public Builder baseUrl(HttpUrl baseUrl) {
            this.baseUrl = (HttpUrl)io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)baseUrl, (String)"baseUrl == null");
            return this;
        }

        public Builder addConverterFactory(Converter.Factory converterFactory) {
            this.converters.add((Converter.Factory)io.apptik.comm.jus.toolbox.Utils.checkNotNull((Object)converterFactory, (String)"converterFactory == null"));
            return this;
        }

        public Builder validateEagerly(boolean validateEagerly) {
            this.validateEagerly = validateEagerly;
            return this;
        }

        public Builder validateEagerly() {
            this.validateEagerly(true);
            return this;
        }

        public Builder execManually(boolean execManually) {
            this.execManually = execManually;
            return this;
        }

        public Builder execManually() {
            this.execManually(true);
            return this;
        }

        public RetroProxy build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            if (this.requestQueue == null) {
                this.requestQueue = Jus.newRequestQueue();
            }
            ArrayList<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>(this.converters);
            return new RetroProxy(this.requestQueue, this.baseUrl, converterFactories, this.validateEagerly, this.execManually);
        }
    }
}

